// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** The capacity value. */
public enum Capacity {
    /** Enum value 500. */
    FIVE_ZERO_ZERO(500L),

    /** Enum value 1000. */
    ONE_ZERO_ZERO_ZERO(1000L),

    /** Enum value 2000. */
    TWO_ZERO_ZERO_ZERO(2000L),

    /** Enum value 5000. */
    FIVE_ZERO_ZERO_ZERO(5000L);

    /** The actual serialized value for a Capacity instance. */
    private final long value;

    Capacity(long value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a Capacity instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed Capacity object, or null if unable to parse.
     */
    @JsonCreator
    public static Capacity fromLong(long value) {
        Capacity[] items = Capacity.values();
        for (Capacity item : items) {
            if (item.toLong() == value) {
                return item;
            }
        }
        return null;
    }

    /**
     * De-serializes the instance to long value.
     *
     * @return the long value.
     */
    @JsonValue
    public long toLong() {
        return this.value;
    }
}
