// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Table column. */
@Fluent
public final class Column {
    /*
     * Column name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Column data type.
     */
    @JsonProperty(value = "type")
    private ColumnTypeEnum type;

    /*
     * Column data type logical hint.
     */
    @JsonProperty(value = "dataTypeHint")
    private ColumnDataTypeHintEnum dataTypeHint;

    /*
     * Column display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Column description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Is displayed by default.
     */
    @JsonProperty(value = "isDefaultDisplay", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isDefaultDisplay;

    /*
     * Is column hidden.
     */
    @JsonProperty(value = "isHidden", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isHidden;

    /** Creates an instance of Column class. */
    public Column() {
    }

    /**
     * Get the name property: Column name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Column name.
     *
     * @param name the name value to set.
     * @return the Column object itself.
     */
    public Column withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Column data type.
     *
     * @return the type value.
     */
    public ColumnTypeEnum type() {
        return this.type;
    }

    /**
     * Set the type property: Column data type.
     *
     * @param type the type value to set.
     * @return the Column object itself.
     */
    public Column withType(ColumnTypeEnum type) {
        this.type = type;
        return this;
    }

    /**
     * Get the dataTypeHint property: Column data type logical hint.
     *
     * @return the dataTypeHint value.
     */
    public ColumnDataTypeHintEnum dataTypeHint() {
        return this.dataTypeHint;
    }

    /**
     * Set the dataTypeHint property: Column data type logical hint.
     *
     * @param dataTypeHint the dataTypeHint value to set.
     * @return the Column object itself.
     */
    public Column withDataTypeHint(ColumnDataTypeHintEnum dataTypeHint) {
        this.dataTypeHint = dataTypeHint;
        return this;
    }

    /**
     * Get the displayName property: Column display name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Column display name.
     *
     * @param displayName the displayName value to set.
     * @return the Column object itself.
     */
    public Column withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: Column description.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Column description.
     *
     * @param description the description value to set.
     * @return the Column object itself.
     */
    public Column withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the isDefaultDisplay property: Is displayed by default.
     *
     * @return the isDefaultDisplay value.
     */
    public Boolean isDefaultDisplay() {
        return this.isDefaultDisplay;
    }

    /**
     * Get the isHidden property: Is column hidden.
     *
     * @return the isHidden value.
     */
    public Boolean isHidden() {
        return this.isHidden;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
