// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.loganalytics.fluent.models.DataExportInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Result of the request to list data exports. */
@Fluent
public final class DataExportListResult {
    /*
     * List of data export instances within a workspace..
     */
    @JsonProperty(value = "value")
    private List<DataExportInner> value;

    /** Creates an instance of DataExportListResult class. */
    public DataExportListResult() {
    }

    /**
     * Get the value property: List of data export instances within a workspace..
     *
     * @return the value value.
     */
    public List<DataExportInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of data export instances within a workspace..
     *
     * @param value the value value to set.
     * @return the DataExportListResult object itself.
     */
    public DataExportListResult withValue(List<DataExportInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
