// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.loganalytics.fluent.models.DataSourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list data source by workspace operation response. */
@Fluent
public final class DataSourceListResult {
    /*
     * A list of datasources.
     */
    @JsonProperty(value = "value")
    private List<DataSourceInner> value;

    /*
     * The link (url) to the next page of datasources.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of DataSourceListResult class. */
    public DataSourceListResult() {
    }

    /**
     * Get the value property: A list of datasources.
     *
     * @return the value value.
     */
    public List<DataSourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of datasources.
     *
     * @param value the value value to set.
     * @return the DataSourceListResult object itself.
     */
    public DataSourceListResult withValue(List<DataSourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link (url) to the next page of datasources.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link (url) to the next page of datasources.
     *
     * @param nextLink the nextLink value to set.
     * @return the DataSourceListResult object itself.
     */
    public DataSourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
