// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Properties that define an Log Analytics QueryPack-Query search properties. */
@Fluent
public final class LogAnalyticsQueryPackQuerySearchProperties {
    /*
     * The related metadata items for the function.
     */
    @JsonProperty(value = "related")
    private LogAnalyticsQueryPackQuerySearchPropertiesRelated related;

    /*
     * Tags associated with the query.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, List<String>> tags;

    /** Creates an instance of LogAnalyticsQueryPackQuerySearchProperties class. */
    public LogAnalyticsQueryPackQuerySearchProperties() {
    }

    /**
     * Get the related property: The related metadata items for the function.
     *
     * @return the related value.
     */
    public LogAnalyticsQueryPackQuerySearchPropertiesRelated related() {
        return this.related;
    }

    /**
     * Set the related property: The related metadata items for the function.
     *
     * @param related the related value to set.
     * @return the LogAnalyticsQueryPackQuerySearchProperties object itself.
     */
    public LogAnalyticsQueryPackQuerySearchProperties withRelated(
        LogAnalyticsQueryPackQuerySearchPropertiesRelated related) {
        this.related = related;
        return this;
    }

    /**
     * Get the tags property: Tags associated with the query.
     *
     * @return the tags value.
     */
    public Map<String, List<String>> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags associated with the query.
     *
     * @param tags the tags value to set.
     * @return the LogAnalyticsQueryPackQuerySearchProperties object itself.
     */
    public LogAnalyticsQueryPackQuerySearchProperties withTags(Map<String, List<String>> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (related() != null) {
            related().validate();
        }
    }
}
