// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The related metadata items for the function. */
@Fluent
public final class LogAnalyticsQueryPackQuerySearchPropertiesRelated {
    /*
     * The related categories for the function.
     */
    @JsonProperty(value = "categories")
    private List<String> categories;

    /*
     * The related resource types for the function.
     */
    @JsonProperty(value = "resourceTypes")
    private List<String> resourceTypes;

    /*
     * The related Log Analytics solutions for the function.
     */
    @JsonProperty(value = "solutions")
    private List<String> solutions;

    /** Creates an instance of LogAnalyticsQueryPackQuerySearchPropertiesRelated class. */
    public LogAnalyticsQueryPackQuerySearchPropertiesRelated() {
    }

    /**
     * Get the categories property: The related categories for the function.
     *
     * @return the categories value.
     */
    public List<String> categories() {
        return this.categories;
    }

    /**
     * Set the categories property: The related categories for the function.
     *
     * @param categories the categories value to set.
     * @return the LogAnalyticsQueryPackQuerySearchPropertiesRelated object itself.
     */
    public LogAnalyticsQueryPackQuerySearchPropertiesRelated withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    /**
     * Get the resourceTypes property: The related resource types for the function.
     *
     * @return the resourceTypes value.
     */
    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes property: The related resource types for the function.
     *
     * @param resourceTypes the resourceTypes value to set.
     * @return the LogAnalyticsQueryPackQuerySearchPropertiesRelated object itself.
     */
    public LogAnalyticsQueryPackQuerySearchPropertiesRelated withResourceTypes(List<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the solutions property: The related Log Analytics solutions for the function.
     *
     * @return the solutions value.
     */
    public List<String> solutions() {
        return this.solutions;
    }

    /**
     * Set the solutions property: The related Log Analytics solutions for the function.
     *
     * @param solutions the solutions value to set.
     * @return the LogAnalyticsQueryPackQuerySearchPropertiesRelated object itself.
     */
    public LogAnalyticsQueryPackQuerySearchPropertiesRelated withSolutions(List<String> solutions) {
        this.solutions = solutions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
