// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/** Resource collection API of Queries. */
public interface Queries {
    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with {@link
     *     PagedIterable}.
     */
    PagedIterable<LogAnalyticsQueryPackQuery> list(String resourceGroupName, String queryPackName);

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     *     return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with {@link
     *     PagedIterable}.
     */
    PagedIterable<LogAnalyticsQueryPackQuery> list(
        String resourceGroupName,
        String queryPackName,
        Long top,
        Boolean includeBody,
        String skipToken,
        Context context);

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with {@link
     *     PagedIterable}.
     */
    PagedIterable<LogAnalyticsQueryPackQuery> search(
        String resourceGroupName,
        String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties);

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     *     return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with {@link
     *     PagedIterable}.
     */
    PagedIterable<LogAnalyticsQueryPackQuery> search(
        String resourceGroupName,
        String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties,
        Long top,
        Boolean includeBody,
        String skipToken,
        Context context);

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack along with {@link Response}.
     */
    Response<LogAnalyticsQueryPackQuery> getWithResponse(
        String resourceGroupName, String queryPackName, String id, Context context);

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack.
     */
    LogAnalyticsQueryPackQuery get(String resourceGroupName, String queryPackName, String id);

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String queryPackName, String id, Context context);

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String queryPackName, String id);

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack along with {@link Response}.
     */
    LogAnalyticsQueryPackQuery getById(String id);

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     *
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack along with {@link Response}.
     */
    Response<LogAnalyticsQueryPackQuery> getByIdWithResponse(String id, Context context);

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     *
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new LogAnalyticsQueryPackQuery resource.
     *
     * @param name resource name.
     * @return the first stage of the new LogAnalyticsQueryPackQuery definition.
     */
    LogAnalyticsQueryPackQuery.DefinitionStages.Blank define(String name);
}
