// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Table's schema. */
@Fluent
public final class Schema {
    /*
     * Table name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Table display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Table description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * A list of table custom columns.
     */
    @JsonProperty(value = "columns")
    private List<Column> columns;

    /*
     * A list of table standard columns.
     */
    @JsonProperty(value = "standardColumns", access = JsonProperty.Access.WRITE_ONLY)
    private List<Column> standardColumns;

    /*
     * Table category.
     */
    @JsonProperty(value = "categories", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> categories;

    /*
     * Table labels.
     */
    @JsonProperty(value = "labels", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> labels;

    /*
     * Table's creator.
     */
    @JsonProperty(value = "source", access = JsonProperty.Access.WRITE_ONLY)
    private SourceEnum source;

    /*
     * Table's creator.
     */
    @JsonProperty(value = "tableType", access = JsonProperty.Access.WRITE_ONLY)
    private TableTypeEnum tableType;

    /*
     * The subtype describes what APIs can be used to interact with the table, and what features are available against
     * it.
     */
    @JsonProperty(value = "tableSubType", access = JsonProperty.Access.WRITE_ONLY)
    private TableSubTypeEnum tableSubType;

    /*
     * List of solutions the table is affiliated with
     */
    @JsonProperty(value = "solutions", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> solutions;

    /** Creates an instance of Schema class. */
    public Schema() {
    }

    /**
     * Get the name property: Table name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Table name.
     *
     * @param name the name value to set.
     * @return the Schema object itself.
     */
    public Schema withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: Table display name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Table display name.
     *
     * @param displayName the displayName value to set.
     * @return the Schema object itself.
     */
    public Schema withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: Table description.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Table description.
     *
     * @param description the description value to set.
     * @return the Schema object itself.
     */
    public Schema withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the columns property: A list of table custom columns.
     *
     * @return the columns value.
     */
    public List<Column> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: A list of table custom columns.
     *
     * @param columns the columns value to set.
     * @return the Schema object itself.
     */
    public Schema withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the standardColumns property: A list of table standard columns.
     *
     * @return the standardColumns value.
     */
    public List<Column> standardColumns() {
        return this.standardColumns;
    }

    /**
     * Get the categories property: Table category.
     *
     * @return the categories value.
     */
    public List<String> categories() {
        return this.categories;
    }

    /**
     * Get the labels property: Table labels.
     *
     * @return the labels value.
     */
    public List<String> labels() {
        return this.labels;
    }

    /**
     * Get the source property: Table's creator.
     *
     * @return the source value.
     */
    public SourceEnum source() {
        return this.source;
    }

    /**
     * Get the tableType property: Table's creator.
     *
     * @return the tableType value.
     */
    public TableTypeEnum tableType() {
        return this.tableType;
    }

    /**
     * Get the tableSubType property: The subtype describes what APIs can be used to interact with the table, and what
     * features are available against it.
     *
     * @return the tableSubType value.
     */
    public TableSubTypeEnum tableSubType() {
        return this.tableSubType;
    }

    /**
     * Get the solutions property: List of solutions the table is affiliated with.
     *
     * @return the solutions value.
     */
    public List<String> solutions() {
        return this.solutions;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (standardColumns() != null) {
            standardColumns().forEach(e -> e.validate());
        }
    }
}
