// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.TableInner;

/** An immutable client-side representation of Table. */
public interface Table {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     *
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Metadata pertaining to creation and last modification of the resource.
     *
     * @return the systemData value.
     */
    SystemDataAutoGenerated systemData();

    /**
     * Gets the retentionInDays property: The table retention in days, between 4 and 730. Setting this property to -1
     * will default to the workspace retention.
     *
     * @return the retentionInDays value.
     */
    Integer retentionInDays();

    /**
     * Gets the totalRetentionInDays property: The table total retention in days, between 4 and 2556. Setting this
     * property to -1 will default to table retention.
     *
     * @return the totalRetentionInDays value.
     */
    Integer totalRetentionInDays();

    /**
     * Gets the archiveRetentionInDays property: The table data archive retention in days. Calculated as
     * (totalRetentionInDays-retentionInDays).
     *
     * @return the archiveRetentionInDays value.
     */
    Integer archiveRetentionInDays();

    /**
     * Gets the searchResults property: Parameters of the search job that initiated this table.
     *
     * @return the searchResults value.
     */
    SearchResults searchResults();

    /**
     * Gets the restoredLogs property: Parameters of the restore operation that initiated this table.
     *
     * @return the restoredLogs value.
     */
    RestoredLogs restoredLogs();

    /**
     * Gets the resultStatistics property: Search job execution statistics.
     *
     * @return the resultStatistics value.
     */
    ResultStatistics resultStatistics();

    /**
     * Gets the plan property: Instruct the system how to handle and charge the logs ingested to this table.
     *
     * @return the plan value.
     */
    TablePlanEnum plan();

    /**
     * Gets the lastPlanModifiedDate property: The timestamp that table plan was last modified (UTC).
     *
     * @return the lastPlanModifiedDate value.
     */
    String lastPlanModifiedDate();

    /**
     * Gets the schema property: Table schema.
     *
     * @return the schema value.
     */
    Schema schema();

    /**
     * Gets the provisioningState property: Table's current provisioning state. If set to 'updating', indicates a
     * resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is
     * concluded.
     *
     * @return the provisioningState value.
     */
    ProvisioningStateEnum provisioningState();

    /**
     * Gets the retentionInDaysAsDefault property: True - Value originates from workspace retention in days, False -
     * Customer specific.
     *
     * @return the retentionInDaysAsDefault value.
     */
    Boolean retentionInDaysAsDefault();

    /**
     * Gets the totalRetentionInDaysAsDefault property: True - Value originates from retention in days, False - Customer
     * specific.
     *
     * @return the totalRetentionInDaysAsDefault value.
     */
    Boolean totalRetentionInDaysAsDefault();

    /**
     * Gets the name of the resource group.
     *
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.loganalytics.fluent.models.TableInner object.
     *
     * @return the inner object.
     */
    TableInner innerModel();

    /** The entirety of the Table definition. */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /** The Table definition stages. */
    interface DefinitionStages {
        /** The first stage of the Table definition. */
        interface Blank extends WithParentResource {
        }

        /** The stage of the Table definition allowing to specify parent resource. */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, workspaceName.
             *
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param workspaceName The name of the workspace.
             * @return the next definition stage.
             */
            WithCreate withExistingWorkspace(String resourceGroupName, String workspaceName);
        }

        /**
         * The stage of the Table definition which contains all the minimum required properties for the resource to be
         * created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithRetentionInDays,
                DefinitionStages.WithTotalRetentionInDays,
                DefinitionStages.WithSearchResults,
                DefinitionStages.WithRestoredLogs,
                DefinitionStages.WithPlan,
                DefinitionStages.WithSchema {
            /**
             * Executes the create request.
             *
             * @return the created resource.
             */
            Table create();

            /**
             * Executes the create request.
             *
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            Table create(Context context);
        }

        /** The stage of the Table definition allowing to specify retentionInDays. */
        interface WithRetentionInDays {
            /**
             * Specifies the retentionInDays property: The table retention in days, between 4 and 730. Setting this
             * property to -1 will default to the workspace retention..
             *
             * @param retentionInDays The table retention in days, between 4 and 730. Setting this property to -1 will
             *     default to the workspace retention.
             * @return the next definition stage.
             */
            WithCreate withRetentionInDays(Integer retentionInDays);
        }

        /** The stage of the Table definition allowing to specify totalRetentionInDays. */
        interface WithTotalRetentionInDays {
            /**
             * Specifies the totalRetentionInDays property: The table total retention in days, between 4 and 2556.
             * Setting this property to -1 will default to table retention..
             *
             * @param totalRetentionInDays The table total retention in days, between 4 and 2556. Setting this property
             *     to -1 will default to table retention.
             * @return the next definition stage.
             */
            WithCreate withTotalRetentionInDays(Integer totalRetentionInDays);
        }

        /** The stage of the Table definition allowing to specify searchResults. */
        interface WithSearchResults {
            /**
             * Specifies the searchResults property: Parameters of the search job that initiated this table..
             *
             * @param searchResults Parameters of the search job that initiated this table.
             * @return the next definition stage.
             */
            WithCreate withSearchResults(SearchResults searchResults);
        }

        /** The stage of the Table definition allowing to specify restoredLogs. */
        interface WithRestoredLogs {
            /**
             * Specifies the restoredLogs property: Parameters of the restore operation that initiated this table..
             *
             * @param restoredLogs Parameters of the restore operation that initiated this table.
             * @return the next definition stage.
             */
            WithCreate withRestoredLogs(RestoredLogs restoredLogs);
        }

        /** The stage of the Table definition allowing to specify plan. */
        interface WithPlan {
            /**
             * Specifies the plan property: Instruct the system how to handle and charge the logs ingested to this
             * table..
             *
             * @param plan Instruct the system how to handle and charge the logs ingested to this table.
             * @return the next definition stage.
             */
            WithCreate withPlan(TablePlanEnum plan);
        }

        /** The stage of the Table definition allowing to specify schema. */
        interface WithSchema {
            /**
             * Specifies the schema property: Table schema..
             *
             * @param schema Table schema.
             * @return the next definition stage.
             */
            WithCreate withSchema(Schema schema);
        }
    }

    /**
     * Begins update for the Table resource.
     *
     * @return the stage of resource update.
     */
    Table.Update update();

    /** The template for Table update. */
    interface Update
        extends UpdateStages.WithRetentionInDays,
            UpdateStages.WithTotalRetentionInDays,
            UpdateStages.WithSearchResults,
            UpdateStages.WithRestoredLogs,
            UpdateStages.WithPlan,
            UpdateStages.WithSchema {
        /**
         * Executes the update request.
         *
         * @return the updated resource.
         */
        Table apply();

        /**
         * Executes the update request.
         *
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        Table apply(Context context);
    }

    /** The Table update stages. */
    interface UpdateStages {
        /** The stage of the Table update allowing to specify retentionInDays. */
        interface WithRetentionInDays {
            /**
             * Specifies the retentionInDays property: The table retention in days, between 4 and 730. Setting this
             * property to -1 will default to the workspace retention..
             *
             * @param retentionInDays The table retention in days, between 4 and 730. Setting this property to -1 will
             *     default to the workspace retention.
             * @return the next definition stage.
             */
            Update withRetentionInDays(Integer retentionInDays);
        }

        /** The stage of the Table update allowing to specify totalRetentionInDays. */
        interface WithTotalRetentionInDays {
            /**
             * Specifies the totalRetentionInDays property: The table total retention in days, between 4 and 2556.
             * Setting this property to -1 will default to table retention..
             *
             * @param totalRetentionInDays The table total retention in days, between 4 and 2556. Setting this property
             *     to -1 will default to table retention.
             * @return the next definition stage.
             */
            Update withTotalRetentionInDays(Integer totalRetentionInDays);
        }

        /** The stage of the Table update allowing to specify searchResults. */
        interface WithSearchResults {
            /**
             * Specifies the searchResults property: Parameters of the search job that initiated this table..
             *
             * @param searchResults Parameters of the search job that initiated this table.
             * @return the next definition stage.
             */
            Update withSearchResults(SearchResults searchResults);
        }

        /** The stage of the Table update allowing to specify restoredLogs. */
        interface WithRestoredLogs {
            /**
             * Specifies the restoredLogs property: Parameters of the restore operation that initiated this table..
             *
             * @param restoredLogs Parameters of the restore operation that initiated this table.
             * @return the next definition stage.
             */
            Update withRestoredLogs(RestoredLogs restoredLogs);
        }

        /** The stage of the Table update allowing to specify plan. */
        interface WithPlan {
            /**
             * Specifies the plan property: Instruct the system how to handle and charge the logs ingested to this
             * table..
             *
             * @param plan Instruct the system how to handle and charge the logs ingested to this table.
             * @return the next definition stage.
             */
            Update withPlan(TablePlanEnum plan);
        }

        /** The stage of the Table update allowing to specify schema. */
        interface WithSchema {
            /**
             * Specifies the schema property: Table schema..
             *
             * @param schema Table schema.
             * @return the next definition stage.
             */
            Update withSchema(Schema schema);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     *
     * @return the refreshed resource.
     */
    Table refresh();

    /**
     * Refreshes the resource to sync with Azure.
     *
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    Table refresh(Context context);

    /**
     * Migrate a Log Analytics table from support of the Data Collector API and Custom Fields features to support of
     * Data Collection Rule-based Custom Logs.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> migrateWithResponse(Context context);

    /**
     * Migrate a Log Analytics table from support of the Data Collector API and Custom Fields features to support of
     * Data Collection Rule-based Custom Logs.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void migrate();

    /**
     * Cancel a log analytics workspace search results table query run.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> cancelSearchWithResponse(Context context);

    /**
     * Cancel a log analytics workspace search results table query run.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void cancelSearch();
}
