/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.loganalytics.fluent.AvailableServiceTiersClient;
import com.azure.resourcemanager.loganalytics.fluent.models.AvailableServiceTierInner;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class AvailableServiceTiersClientImpl
implements AvailableServiceTiersClient {
    private final AvailableServiceTiersService service;
    private final OperationalInsightsManagementClientImpl client;

    AvailableServiceTiersClientImpl(OperationalInsightsManagementClientImpl client) {
        this.service = (AvailableServiceTiersService)RestProxy.create(AvailableServiceTiersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<AvailableServiceTierInner>>> listByWorkspaceWithResponseAsync(String resourceGroupName, String workspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkspace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "2020-08-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<AvailableServiceTierInner>>> listByWorkspaceWithResponseAsync(String resourceGroupName, String workspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByWorkspace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "2020-08-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<List<AvailableServiceTierInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName) {
        return this.listByWorkspaceWithResponseAsync(resourceGroupName, workspaceName).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<AvailableServiceTierInner>> listByWorkspaceWithResponse(String resourceGroupName, String workspaceName, Context context) {
        return (Response)this.listByWorkspaceWithResponseAsync(resourceGroupName, workspaceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AvailableServiceTierInner> listByWorkspace(String resourceGroupName, String workspaceName) {
        return (List)this.listByWorkspaceWithResponse(resourceGroupName, workspaceName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="OperationalInsightsM")
    public static interface AvailableServiceTiersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/availableServiceTiers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<AvailableServiceTierInner>>> listByWorkspace(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="workspaceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

