/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.StorageInsightConfigsClient;
import com.azure.resourcemanager.loganalytics.fluent.models.StorageInsightInner;
import com.azure.resourcemanager.loganalytics.implementation.StorageInsightImpl;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.StorageInsight;
import com.azure.resourcemanager.loganalytics.models.StorageInsightConfigs;

public final class StorageInsightConfigsImpl
implements StorageInsightConfigs {
    private static final ClientLogger LOGGER = new ClientLogger(StorageInsightConfigsImpl.class);
    private final StorageInsightConfigsClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public StorageInsightConfigsImpl(StorageInsightConfigsClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<StorageInsight> getWithResponse(String resourceGroupName, String workspaceName, String storageInsightName, Context context) {
        Response<StorageInsightInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, storageInsightName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StorageInsightImpl((StorageInsightInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public StorageInsight get(String resourceGroupName, String workspaceName, String storageInsightName) {
        StorageInsightInner inner = this.serviceClient().get(resourceGroupName, workspaceName, storageInsightName);
        if (inner != null) {
            return new StorageInsightImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String workspaceName, String storageInsightName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, workspaceName, storageInsightName, context);
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String storageInsightName) {
        this.serviceClient().delete(resourceGroupName, workspaceName, storageInsightName);
    }

    @Override
    public PagedIterable<StorageInsight> listByWorkspace(String resourceGroupName, String workspaceName) {
        PagedIterable<StorageInsightInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName);
        return Utils.mapPage(inner, inner1 -> new StorageInsightImpl((StorageInsightInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageInsight> listByWorkspace(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<StorageInsightInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName, context);
        return Utils.mapPage(inner, inner1 -> new StorageInsightImpl((StorageInsightInner)((Object)inner1), this.manager()));
    }

    @Override
    public StorageInsight getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String storageInsightName = Utils.getValueFromIdByName(id, "storageInsightConfigs");
        if (storageInsightName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageInsightConfigs'.", id)));
        }
        return (StorageInsight)this.getWithResponse(resourceGroupName, workspaceName, storageInsightName, Context.NONE).getValue();
    }

    @Override
    public Response<StorageInsight> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String storageInsightName = Utils.getValueFromIdByName(id, "storageInsightConfigs");
        if (storageInsightName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageInsightConfigs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, workspaceName, storageInsightName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String storageInsightName = Utils.getValueFromIdByName(id, "storageInsightConfigs");
        if (storageInsightName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageInsightConfigs'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, workspaceName, storageInsightName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String storageInsightName = Utils.getValueFromIdByName(id, "storageInsightConfigs");
        if (storageInsightName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageInsightConfigs'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, workspaceName, storageInsightName, context);
    }

    private StorageInsightConfigsClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageInsightImpl define(String name) {
        return new StorageInsightImpl(name, this.manager());
    }
}

