// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.SkuNameEnum;
import java.io.IOException;

/**
 * Service Tier details.
 */
@Immutable
public final class AvailableServiceTierInner implements JsonSerializable<AvailableServiceTierInner> {
    /*
     * The name of the Service Tier.
     */
    private SkuNameEnum serviceTier;

    /*
     * True if the Service Tier is enabled for the workspace.
     */
    private Boolean enabled;

    /*
     * The minimum retention for the Service Tier, in days.
     */
    private Long minimumRetention;

    /*
     * The maximum retention for the Service Tier, in days.
     */
    private Long maximumRetention;

    /*
     * The default retention for the Service Tier, in days.
     */
    private Long defaultRetention;

    /*
     * The capacity reservation level in GB per day. Returned for the Capacity Reservation Service Tier.
     */
    private Long capacityReservationLevel;

    /*
     * Time when the sku was last updated for the workspace. Returned for the Capacity Reservation Service Tier.
     */
    private String lastSkuUpdate;

    /**
     * Creates an instance of AvailableServiceTierInner class.
     */
    public AvailableServiceTierInner() {
    }

    /**
     * Get the serviceTier property: The name of the Service Tier.
     * 
     * @return the serviceTier value.
     */
    public SkuNameEnum serviceTier() {
        return this.serviceTier;
    }

    /**
     * Get the enabled property: True if the Service Tier is enabled for the workspace.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Get the minimumRetention property: The minimum retention for the Service Tier, in days.
     * 
     * @return the minimumRetention value.
     */
    public Long minimumRetention() {
        return this.minimumRetention;
    }

    /**
     * Get the maximumRetention property: The maximum retention for the Service Tier, in days.
     * 
     * @return the maximumRetention value.
     */
    public Long maximumRetention() {
        return this.maximumRetention;
    }

    /**
     * Get the defaultRetention property: The default retention for the Service Tier, in days.
     * 
     * @return the defaultRetention value.
     */
    public Long defaultRetention() {
        return this.defaultRetention;
    }

    /**
     * Get the capacityReservationLevel property: The capacity reservation level in GB per day. Returned for the
     * Capacity Reservation Service Tier.
     * 
     * @return the capacityReservationLevel value.
     */
    public Long capacityReservationLevel() {
        return this.capacityReservationLevel;
    }

    /**
     * Get the lastSkuUpdate property: Time when the sku was last updated for the workspace. Returned for the Capacity
     * Reservation Service Tier.
     * 
     * @return the lastSkuUpdate value.
     */
    public String lastSkuUpdate() {
        return this.lastSkuUpdate;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailableServiceTierInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailableServiceTierInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvailableServiceTierInner.
     */
    public static AvailableServiceTierInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailableServiceTierInner deserializedAvailableServiceTierInner = new AvailableServiceTierInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceTier".equals(fieldName)) {
                    deserializedAvailableServiceTierInner.serviceTier = SkuNameEnum.fromString(reader.getString());
                } else if ("enabled".equals(fieldName)) {
                    deserializedAvailableServiceTierInner.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("minimumRetention".equals(fieldName)) {
                    deserializedAvailableServiceTierInner.minimumRetention = reader.getNullable(JsonReader::getLong);
                } else if ("maximumRetention".equals(fieldName)) {
                    deserializedAvailableServiceTierInner.maximumRetention = reader.getNullable(JsonReader::getLong);
                } else if ("defaultRetention".equals(fieldName)) {
                    deserializedAvailableServiceTierInner.defaultRetention = reader.getNullable(JsonReader::getLong);
                } else if ("capacityReservationLevel".equals(fieldName)) {
                    deserializedAvailableServiceTierInner.capacityReservationLevel
                        = reader.getNullable(JsonReader::getLong);
                } else if ("lastSkuUpdate".equals(fieldName)) {
                    deserializedAvailableServiceTierInner.lastSkuUpdate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailableServiceTierInner;
        });
    }
}
