// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import java.io.IOException;

/**
 * Log Analytics cluster patch properties.
 */
@Fluent
public final class ClusterPatchProperties implements JsonSerializable<ClusterPatchProperties> {
    /*
     * The associated key properties.
     */
    private KeyVaultProperties keyVaultProperties;

    /*
     * The cluster's billing type.
     */
    private BillingType billingType;

    /**
     * Creates an instance of ClusterPatchProperties class.
     */
    public ClusterPatchProperties() {
    }

    /**
     * Get the keyVaultProperties property: The associated key properties.
     * 
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the keyVaultProperties property: The associated key properties.
     * 
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the ClusterPatchProperties object itself.
     */
    public ClusterPatchProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    /**
     * Get the billingType property: The cluster's billing type.
     * 
     * @return the billingType value.
     */
    public BillingType billingType() {
        return this.billingType;
    }

    /**
     * Set the billingType property: The cluster's billing type.
     * 
     * @param billingType the billingType value to set.
     * @return the ClusterPatchProperties object itself.
     */
    public ClusterPatchProperties withBillingType(BillingType billingType) {
        this.billingType = billingType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultProperties() != null) {
            keyVaultProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyVaultProperties", this.keyVaultProperties);
        jsonWriter.writeStringField("billingType", this.billingType == null ? null : this.billingType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClusterPatchProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClusterPatchProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClusterPatchProperties.
     */
    public static ClusterPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterPatchProperties deserializedClusterPatchProperties = new ClusterPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedClusterPatchProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                } else if ("billingType".equals(fieldName)) {
                    deserializedClusterPatchProperties.billingType = BillingType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClusterPatchProperties;
        });
    }
}
