// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.AssociatedWorkspace;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationProperties;
import com.azure.resourcemanager.loganalytics.models.ClusterEntityStatus;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import java.io.IOException;
import java.util.List;

/**
 * Cluster properties.
 */
@Fluent
public final class ClusterProperties implements JsonSerializable<ClusterProperties> {
    /*
     * The ID associated with the cluster.
     */
    private String clusterId;

    /*
     * The provisioning state of the cluster.
     */
    private ClusterEntityStatus provisioningState;

    /*
     * Configures whether cluster will use double encryption. This Property can not be modified after cluster creation.
     * Default value is 'true'
     */
    private Boolean isDoubleEncryptionEnabled;

    /*
     * Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure
     * Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value
     * is 'true' if region supports Availability Zones.
     */
    private Boolean isAvailabilityZonesEnabled;

    /*
     * The cluster's billing type.
     */
    private BillingType billingType;

    /*
     * The associated key properties.
     */
    private KeyVaultProperties keyVaultProperties;

    /*
     * The last time the cluster was updated.
     */
    private String lastModifiedDate;

    /*
     * The cluster creation time
     */
    private String createdDate;

    /*
     * The list of Log Analytics workspaces associated with the cluster
     */
    private List<AssociatedWorkspace> associatedWorkspaces;

    /*
     * Additional properties for capacity reservation
     */
    private CapacityReservationProperties capacityReservationProperties;

    /**
     * Creates an instance of ClusterProperties class.
     */
    public ClusterProperties() {
    }

    /**
     * Get the clusterId property: The ID associated with the cluster.
     * 
     * @return the clusterId value.
     */
    public String clusterId() {
        return this.clusterId;
    }

    /**
     * Get the provisioningState property: The provisioning state of the cluster.
     * 
     * @return the provisioningState value.
     */
    public ClusterEntityStatus provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the isDoubleEncryptionEnabled property: Configures whether cluster will use double encryption. This Property
     * can not be modified after cluster creation. Default value is 'true'.
     * 
     * @return the isDoubleEncryptionEnabled value.
     */
    public Boolean isDoubleEncryptionEnabled() {
        return this.isDoubleEncryptionEnabled;
    }

    /**
     * Set the isDoubleEncryptionEnabled property: Configures whether cluster will use double encryption. This Property
     * can not be modified after cluster creation. Default value is 'true'.
     * 
     * @param isDoubleEncryptionEnabled the isDoubleEncryptionEnabled value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withIsDoubleEncryptionEnabled(Boolean isDoubleEncryptionEnabled) {
        this.isDoubleEncryptionEnabled = isDoubleEncryptionEnabled;
        return this;
    }

    /**
     * Get the isAvailabilityZonesEnabled property: Sets whether the cluster will support availability zones. This can
     * be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be
     * modified after cluster creation. Default value is 'true' if region supports Availability Zones.
     * 
     * @return the isAvailabilityZonesEnabled value.
     */
    public Boolean isAvailabilityZonesEnabled() {
        return this.isAvailabilityZonesEnabled;
    }

    /**
     * Set the isAvailabilityZonesEnabled property: Sets whether the cluster will support availability zones. This can
     * be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be
     * modified after cluster creation. Default value is 'true' if region supports Availability Zones.
     * 
     * @param isAvailabilityZonesEnabled the isAvailabilityZonesEnabled value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withIsAvailabilityZonesEnabled(Boolean isAvailabilityZonesEnabled) {
        this.isAvailabilityZonesEnabled = isAvailabilityZonesEnabled;
        return this;
    }

    /**
     * Get the billingType property: The cluster's billing type.
     * 
     * @return the billingType value.
     */
    public BillingType billingType() {
        return this.billingType;
    }

    /**
     * Set the billingType property: The cluster's billing type.
     * 
     * @param billingType the billingType value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withBillingType(BillingType billingType) {
        this.billingType = billingType;
        return this;
    }

    /**
     * Get the keyVaultProperties property: The associated key properties.
     * 
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the keyVaultProperties property: The associated key properties.
     * 
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    /**
     * Get the lastModifiedDate property: The last time the cluster was updated.
     * 
     * @return the lastModifiedDate value.
     */
    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    /**
     * Get the createdDate property: The cluster creation time.
     * 
     * @return the createdDate value.
     */
    public String createdDate() {
        return this.createdDate;
    }

    /**
     * Get the associatedWorkspaces property: The list of Log Analytics workspaces associated with the cluster.
     * 
     * @return the associatedWorkspaces value.
     */
    public List<AssociatedWorkspace> associatedWorkspaces() {
        return this.associatedWorkspaces;
    }

    /**
     * Set the associatedWorkspaces property: The list of Log Analytics workspaces associated with the cluster.
     * 
     * @param associatedWorkspaces the associatedWorkspaces value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withAssociatedWorkspaces(List<AssociatedWorkspace> associatedWorkspaces) {
        this.associatedWorkspaces = associatedWorkspaces;
        return this;
    }

    /**
     * Get the capacityReservationProperties property: Additional properties for capacity reservation.
     * 
     * @return the capacityReservationProperties value.
     */
    public CapacityReservationProperties capacityReservationProperties() {
        return this.capacityReservationProperties;
    }

    /**
     * Set the capacityReservationProperties property: Additional properties for capacity reservation.
     * 
     * @param capacityReservationProperties the capacityReservationProperties value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties
        withCapacityReservationProperties(CapacityReservationProperties capacityReservationProperties) {
        this.capacityReservationProperties = capacityReservationProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultProperties() != null) {
            keyVaultProperties().validate();
        }
        if (associatedWorkspaces() != null) {
            associatedWorkspaces().forEach(e -> e.validate());
        }
        if (capacityReservationProperties() != null) {
            capacityReservationProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDoubleEncryptionEnabled", this.isDoubleEncryptionEnabled);
        jsonWriter.writeBooleanField("isAvailabilityZonesEnabled", this.isAvailabilityZonesEnabled);
        jsonWriter.writeStringField("billingType", this.billingType == null ? null : this.billingType.toString());
        jsonWriter.writeJsonField("keyVaultProperties", this.keyVaultProperties);
        jsonWriter.writeArrayField("associatedWorkspaces", this.associatedWorkspaces,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("capacityReservationProperties", this.capacityReservationProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClusterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClusterProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClusterProperties.
     */
    public static ClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterProperties deserializedClusterProperties = new ClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clusterId".equals(fieldName)) {
                    deserializedClusterProperties.clusterId = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedClusterProperties.provisioningState
                        = ClusterEntityStatus.fromString(reader.getString());
                } else if ("isDoubleEncryptionEnabled".equals(fieldName)) {
                    deserializedClusterProperties.isDoubleEncryptionEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isAvailabilityZonesEnabled".equals(fieldName)) {
                    deserializedClusterProperties.isAvailabilityZonesEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("billingType".equals(fieldName)) {
                    deserializedClusterProperties.billingType = BillingType.fromString(reader.getString());
                } else if ("keyVaultProperties".equals(fieldName)) {
                    deserializedClusterProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                } else if ("lastModifiedDate".equals(fieldName)) {
                    deserializedClusterProperties.lastModifiedDate = reader.getString();
                } else if ("createdDate".equals(fieldName)) {
                    deserializedClusterProperties.createdDate = reader.getString();
                } else if ("associatedWorkspaces".equals(fieldName)) {
                    List<AssociatedWorkspace> associatedWorkspaces
                        = reader.readArray(reader1 -> AssociatedWorkspace.fromJson(reader1));
                    deserializedClusterProperties.associatedWorkspaces = associatedWorkspaces;
                } else if ("capacityReservationProperties".equals(fieldName)) {
                    deserializedClusterProperties.capacityReservationProperties
                        = CapacityReservationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClusterProperties;
        });
    }
}
