// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.DataSourceKind;
import java.io.IOException;
import java.util.Map;

/**
 * Datasources under OMS Workspace.
 */
@Fluent
public final class DataSourceInner extends ProxyResource {
    /*
     * The data source properties in raw json format, each kind of data source have it's own schema.
     */
    private Object properties;

    /*
     * The ETag of the data source.
     */
    private String etag;

    /*
     * The kind of the DataSource.
     */
    private DataSourceKind kind;

    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DataSourceInner class.
     */
    public DataSourceInner() {
    }

    /**
     * Get the properties property: The data source properties in raw json format, each kind of data source have it's
     * own schema.
     * 
     * @return the properties value.
     */
    public Object properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The data source properties in raw json format, each kind of data source have it's
     * own schema.
     * 
     * @param properties the properties value to set.
     * @return the DataSourceInner object itself.
     */
    public DataSourceInner withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the etag property: The ETag of the data source.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: The ETag of the data source.
     * 
     * @param etag the etag value to set.
     * @return the DataSourceInner object itself.
     */
    public DataSourceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the kind property: The kind of the DataSource.
     * 
     * @return the kind value.
     */
    public DataSourceKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The kind of the DataSource.
     * 
     * @param kind the kind value to set.
     * @return the DataSourceInner object itself.
     */
    public DataSourceInner withKind(DataSourceKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the DataSourceInner object itself.
     */
    public DataSourceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model DataSourceInner"));
        }
        if (kind() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property kind in model DataSourceInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataSourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataSourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataSourceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataSourceInner.
     */
    public static DataSourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataSourceInner deserializedDataSourceInner = new DataSourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDataSourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDataSourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDataSourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDataSourceInner.properties = reader.readUntyped();
                } else if ("kind".equals(fieldName)) {
                    deserializedDataSourceInner.kind = DataSourceKind.fromString(reader.getString());
                } else if ("etag".equals(fieldName)) {
                    deserializedDataSourceInner.etag = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDataSourceInner.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataSourceInner;
        });
    }
}
