// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Intelligence Pack containing a string name and boolean indicating if it's enabled.
 */
@Fluent
public final class IntelligencePackInner implements JsonSerializable<IntelligencePackInner> {
    /*
     * The name of the intelligence pack.
     */
    private String name;

    /*
     * The enabled boolean for the intelligence pack.
     */
    private Boolean enabled;

    /*
     * The display name of the intelligence pack.
     */
    private String displayName;

    /**
     * Creates an instance of IntelligencePackInner class.
     */
    public IntelligencePackInner() {
    }

    /**
     * Get the name property: The name of the intelligence pack.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the intelligence pack.
     * 
     * @param name the name value to set.
     * @return the IntelligencePackInner object itself.
     */
    public IntelligencePackInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the enabled property: The enabled boolean for the intelligence pack.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: The enabled boolean for the intelligence pack.
     * 
     * @param enabled the enabled value to set.
     * @return the IntelligencePackInner object itself.
     */
    public IntelligencePackInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the displayName property: The display name of the intelligence pack.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the intelligence pack.
     * 
     * @param displayName the displayName value to set.
     * @return the IntelligencePackInner object itself.
     */
    public IntelligencePackInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("displayName", this.displayName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IntelligencePackInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IntelligencePackInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IntelligencePackInner.
     */
    public static IntelligencePackInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IntelligencePackInner deserializedIntelligencePackInner = new IntelligencePackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedIntelligencePackInner.name = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedIntelligencePackInner.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("displayName".equals(fieldName)) {
                    deserializedIntelligencePackInner.displayName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIntelligencePackInner;
        });
    }
}
