// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.DataSourceType;
import java.io.IOException;
import java.util.List;

/**
 * Linked storage accounts top level resource container.
 */
@Fluent
public final class LinkedStorageAccountsResourceInner extends ProxyResource {
    /*
     * Linked storage accounts properties.
     */
    private LinkedStorageAccountsProperties innerProperties = new LinkedStorageAccountsProperties();

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of LinkedStorageAccountsResourceInner class.
     */
    public LinkedStorageAccountsResourceInner() {
    }

    /**
     * Get the innerProperties property: Linked storage accounts properties.
     * 
     * @return the innerProperties value.
     */
    private LinkedStorageAccountsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the dataSourceType property: Linked storage accounts type.
     * 
     * @return the dataSourceType value.
     */
    public DataSourceType dataSourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().dataSourceType();
    }

    /**
     * Get the storageAccountIds property: Linked storage accounts resources ids.
     * 
     * @return the storageAccountIds value.
     */
    public List<String> storageAccountIds() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountIds();
    }

    /**
     * Set the storageAccountIds property: Linked storage accounts resources ids.
     * 
     * @param storageAccountIds the storageAccountIds value to set.
     * @return the LinkedStorageAccountsResourceInner object itself.
     */
    public LinkedStorageAccountsResourceInner withStorageAccountIds(List<String> storageAccountIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedStorageAccountsProperties();
        }
        this.innerProperties().withStorageAccountIds(storageAccountIds);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model LinkedStorageAccountsResourceInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LinkedStorageAccountsResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LinkedStorageAccountsResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LinkedStorageAccountsResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LinkedStorageAccountsResourceInner.
     */
    public static LinkedStorageAccountsResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LinkedStorageAccountsResourceInner deserializedLinkedStorageAccountsResourceInner
                = new LinkedStorageAccountsResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedLinkedStorageAccountsResourceInner.innerProperties
                        = LinkedStorageAccountsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLinkedStorageAccountsResourceInner;
        });
    }
}
