// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties that define a Log Analytics QueryPack resource.
 */
@Immutable
public final class LogAnalyticsQueryPackProperties implements JsonSerializable<LogAnalyticsQueryPackProperties> {
    /*
     * The unique ID of your application. This field cannot be changed.
     */
    private String queryPackId;

    /*
     * Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
     */
    private OffsetDateTime timeCreated;

    /*
     * Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
     */
    private OffsetDateTime timeModified;

    /*
     * Current state of this QueryPack: whether or not is has been provisioned within the resource group it is defined.
     * Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled,
     * and Failed.
     */
    private String provisioningState;

    /**
     * Creates an instance of LogAnalyticsQueryPackProperties class.
     */
    public LogAnalyticsQueryPackProperties() {
    }

    /**
     * Get the queryPackId property: The unique ID of your application. This field cannot be changed.
     * 
     * @return the queryPackId value.
     */
    public String queryPackId() {
        return this.queryPackId;
    }

    /**
     * Get the timeCreated property: Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get the timeModified property: Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
     * 
     * @return the timeModified value.
     */
    public OffsetDateTime timeModified() {
        return this.timeModified;
    }

    /**
     * Get the provisioningState property: Current state of this QueryPack: whether or not is has been provisioned
     * within the resource group it is defined. Users cannot change this value but are able to read from it. Values will
     * include Succeeded, Deploying, Canceled, and Failed.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogAnalyticsQueryPackProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogAnalyticsQueryPackProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LogAnalyticsQueryPackProperties.
     */
    public static LogAnalyticsQueryPackProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogAnalyticsQueryPackProperties deserializedLogAnalyticsQueryPackProperties
                = new LogAnalyticsQueryPackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("queryPackId".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackProperties.queryPackId = reader.getString();
                } else if ("timeCreated".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackProperties.timeCreated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("timeModified".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackProperties.timeModified = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackProperties.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogAnalyticsQueryPackProperties;
        });
    }
}
