// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQueryPropertiesRelated;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Properties that define an Log Analytics QueryPack-Query resource.
 */
@Fluent
public final class LogAnalyticsQueryPackQueryProperties
    implements JsonSerializable<LogAnalyticsQueryPackQueryProperties> {
    /*
     * The unique ID of your application. This field cannot be changed.
     */
    private String id;

    /*
     * Unique display name for your query within the Query Pack.
     */
    private String displayName;

    /*
     * Creation Date for the Log Analytics Query, in ISO 8601 format.
     */
    private OffsetDateTime timeCreated;

    /*
     * Last modified date of the Log Analytics Query, in ISO 8601 format.
     */
    private OffsetDateTime timeModified;

    /*
     * Object Id of user creating the query.
     */
    private String author;

    /*
     * Description of the query.
     */
    private String description;

    /*
     * Body of the query.
     */
    private String body;

    /*
     * The related metadata items for the function.
     */
    private LogAnalyticsQueryPackQueryPropertiesRelated related;

    /*
     * Tags associated with the query.
     */
    private Map<String, List<String>> tags;

    /*
     * Additional properties that can be set for the query.
     */
    private Object properties;

    /**
     * Creates an instance of LogAnalyticsQueryPackQueryProperties class.
     */
    public LogAnalyticsQueryPackQueryProperties() {
    }

    /**
     * Get the id property: The unique ID of your application. This field cannot be changed.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Unique display name for your query within the Query Pack.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Unique display name for your query within the Query Pack.
     * 
     * @param displayName the displayName value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the timeCreated property: Creation Date for the Log Analytics Query, in ISO 8601 format.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get the timeModified property: Last modified date of the Log Analytics Query, in ISO 8601 format.
     * 
     * @return the timeModified value.
     */
    public OffsetDateTime timeModified() {
        return this.timeModified;
    }

    /**
     * Get the author property: Object Id of user creating the query.
     * 
     * @return the author value.
     */
    public String author() {
        return this.author;
    }

    /**
     * Get the description property: Description of the query.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the query.
     * 
     * @param description the description value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the body property: Body of the query.
     * 
     * @return the body value.
     */
    public String body() {
        return this.body;
    }

    /**
     * Set the body property: Body of the query.
     * 
     * @param body the body value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withBody(String body) {
        this.body = body;
        return this;
    }

    /**
     * Get the related property: The related metadata items for the function.
     * 
     * @return the related value.
     */
    public LogAnalyticsQueryPackQueryPropertiesRelated related() {
        return this.related;
    }

    /**
     * Set the related property: The related metadata items for the function.
     * 
     * @param related the related value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withRelated(LogAnalyticsQueryPackQueryPropertiesRelated related) {
        this.related = related;
        return this;
    }

    /**
     * Get the tags property: Tags associated with the query.
     * 
     * @return the tags value.
     */
    public Map<String, List<String>> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags associated with the query.
     * 
     * @param tags the tags value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withTags(Map<String, List<String>> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: Additional properties that can be set for the query.
     * 
     * @return the properties value.
     */
    public Object properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Additional properties that can be set for the query.
     * 
     * @param properties the properties value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (displayName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property displayName in model LogAnalyticsQueryPackQueryProperties"));
        }
        if (body() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property body in model LogAnalyticsQueryPackQueryProperties"));
        }
        if (related() != null) {
            related().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogAnalyticsQueryPackQueryProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("related", this.related);
        jsonWriter.writeMapField("tags", this.tags,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeUntypedField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogAnalyticsQueryPackQueryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogAnalyticsQueryPackQueryProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogAnalyticsQueryPackQueryProperties.
     */
    public static LogAnalyticsQueryPackQueryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogAnalyticsQueryPackQueryProperties deserializedLogAnalyticsQueryPackQueryProperties
                = new LogAnalyticsQueryPackQueryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.displayName = reader.getString();
                } else if ("body".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.body = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.id = reader.getString();
                } else if ("timeCreated".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.timeCreated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("timeModified".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.timeModified = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("author".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.author = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.description = reader.getString();
                } else if ("related".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.related
                        = LogAnalyticsQueryPackQueryPropertiesRelated.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, List<String>> tags
                        = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    deserializedLogAnalyticsQueryPackQueryProperties.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedLogAnalyticsQueryPackQueryProperties.properties = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogAnalyticsQueryPackQueryProperties;
        });
    }
}
