// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The status of operation.
 */
@Fluent
public final class OperationStatusInner implements JsonSerializable<OperationStatusInner> {
    /*
     * The operation Id.
     */
    private String id;

    /*
     * The operation name.
     */
    private String name;

    /*
     * The start time of the operation.
     */
    private String startTime;

    /*
     * The end time of the operation.
     */
    private String endTime;

    /*
     * The status of the operation.
     */
    private String status;

    /*
     * The error detail of the operation if any.
     */
    private ManagementError error;

    /**
     * Creates an instance of OperationStatusInner class.
     */
    public OperationStatusInner() {
    }

    /**
     * Get the id property: The operation Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The operation Id.
     * 
     * @param id the id value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The operation name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The operation name.
     * 
     * @param name the name value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the startTime property: The start time of the operation.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The start time of the operation.
     * 
     * @param startTime the startTime value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The end time of the operation.
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The end time of the operation.
     * 
     * @param endTime the endTime value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the status property: The status of the operation.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the operation.
     * 
     * @param status the status value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the error property: The error detail of the operation if any.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The error detail of the operation if any.
     * 
     * @param error the error value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationStatusInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationStatusInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationStatusInner.
     */
    public static OperationStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationStatusInner deserializedOperationStatusInner = new OperationStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedOperationStatusInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedOperationStatusInner.name = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedOperationStatusInner.startTime = reader.getString();
                } else if ("endTime".equals(fieldName)) {
                    deserializedOperationStatusInner.endTime = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedOperationStatusInner.status = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedOperationStatusInner.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationStatusInner;
        });
    }
}
