// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The saved search list operation response.
 */
@Fluent
public final class SavedSearchesListResultInner implements JsonSerializable<SavedSearchesListResultInner> {
    /*
     * The array of result values.
     */
    private List<SavedSearchInner> value;

    /**
     * Creates an instance of SavedSearchesListResultInner class.
     */
    public SavedSearchesListResultInner() {
    }

    /**
     * Get the value property: The array of result values.
     * 
     * @return the value value.
     */
    public List<SavedSearchInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The array of result values.
     * 
     * @param value the value value to set.
     * @return the SavedSearchesListResultInner object itself.
     */
    public SavedSearchesListResultInner withValue(List<SavedSearchInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SavedSearchesListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SavedSearchesListResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SavedSearchesListResultInner.
     */
    public static SavedSearchesListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SavedSearchesListResultInner deserializedSavedSearchesListResultInner = new SavedSearchesListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SavedSearchInner> value = reader.readArray(reader1 -> SavedSearchInner.fromJson(reader1));
                    deserializedSavedSearchesListResultInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSavedSearchesListResultInner;
        });
    }
}
