// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.StorageAccount;
import com.azure.resourcemanager.loganalytics.models.StorageInsightStatus;
import java.io.IOException;
import java.util.List;

/**
 * Storage insight properties.
 */
@Fluent
public final class StorageInsightProperties implements JsonSerializable<StorageInsightProperties> {
    /*
     * The names of the blob containers that the workspace should read
     */
    private List<String> containers;

    /*
     * The names of the Azure tables that the workspace should read
     */
    private List<String> tables;

    /*
     * The storage account connection details
     */
    private StorageAccount storageAccount;

    /*
     * The status of the storage insight
     */
    private StorageInsightStatus status;

    /**
     * Creates an instance of StorageInsightProperties class.
     */
    public StorageInsightProperties() {
    }

    /**
     * Get the containers property: The names of the blob containers that the workspace should read.
     * 
     * @return the containers value.
     */
    public List<String> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: The names of the blob containers that the workspace should read.
     * 
     * @param containers the containers value to set.
     * @return the StorageInsightProperties object itself.
     */
    public StorageInsightProperties withContainers(List<String> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the tables property: The names of the Azure tables that the workspace should read.
     * 
     * @return the tables value.
     */
    public List<String> tables() {
        return this.tables;
    }

    /**
     * Set the tables property: The names of the Azure tables that the workspace should read.
     * 
     * @param tables the tables value to set.
     * @return the StorageInsightProperties object itself.
     */
    public StorageInsightProperties withTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the storageAccount property: The storage account connection details.
     * 
     * @return the storageAccount value.
     */
    public StorageAccount storageAccount() {
        return this.storageAccount;
    }

    /**
     * Set the storageAccount property: The storage account connection details.
     * 
     * @param storageAccount the storageAccount value to set.
     * @return the StorageInsightProperties object itself.
     */
    public StorageInsightProperties withStorageAccount(StorageAccount storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    /**
     * Get the status property: The status of the storage insight.
     * 
     * @return the status value.
     */
    public StorageInsightStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageAccount() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageAccount in model StorageInsightProperties"));
        } else {
            storageAccount().validate();
        }
        if (status() != null) {
            status().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageInsightProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("storageAccount", this.storageAccount);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageInsightProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageInsightProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageInsightProperties.
     */
    public static StorageInsightProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageInsightProperties deserializedStorageInsightProperties = new StorageInsightProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccount".equals(fieldName)) {
                    deserializedStorageInsightProperties.storageAccount = StorageAccount.fromJson(reader);
                } else if ("containers".equals(fieldName)) {
                    List<String> containers = reader.readArray(reader1 -> reader1.getString());
                    deserializedStorageInsightProperties.containers = containers;
                } else if ("tables".equals(fieldName)) {
                    List<String> tables = reader.readArray(reader1 -> reader1.getString());
                    deserializedStorageInsightProperties.tables = tables;
                } else if ("status".equals(fieldName)) {
                    deserializedStorageInsightProperties.status = StorageInsightStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageInsightProperties;
        });
    }
}
