// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.loganalytics.models.PublicNetworkAccessType;
import com.azure.resourcemanager.loganalytics.models.WorkspaceCapping;
import com.azure.resourcemanager.loganalytics.models.WorkspaceEntityStatus;
import com.azure.resourcemanager.loganalytics.models.WorkspaceFeatures;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSku;
import java.io.IOException;
import java.util.List;

/**
 * Workspace properties.
 */
@Fluent
public final class WorkspaceProperties implements JsonSerializable<WorkspaceProperties> {
    /*
     * The provisioning state of the workspace.
     */
    private WorkspaceEntityStatus provisioningState;

    /*
     * This is a read-only property. Represents the ID associated with the workspace.
     */
    private String customerId;

    /*
     * The SKU of the workspace.
     */
    private WorkspaceSku sku;

    /*
     * The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for
     * details.
     */
    private Integer retentionInDays;

    /*
     * The daily volume cap for ingestion.
     */
    private WorkspaceCapping workspaceCapping;

    /*
     * Workspace creation date.
     */
    private String createdDate;

    /*
     * Workspace modification date.
     */
    private String modifiedDate;

    /*
     * The network access type for accessing Log Analytics ingestion.
     */
    private PublicNetworkAccessType publicNetworkAccessForIngestion;

    /*
     * The network access type for accessing Log Analytics query.
     */
    private PublicNetworkAccessType publicNetworkAccessForQuery;

    /*
     * Indicates whether customer managed storage is mandatory for query management.
     */
    private Boolean forceCmkForQuery;

    /*
     * List of linked private link scope resources.
     */
    private List<PrivateLinkScopedResource> privateLinkScopedResources;

    /*
     * Workspace features.
     */
    private WorkspaceFeatures features;

    /*
     * The resource ID of the default Data Collection Rule to use for this workspace. Expected format is -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/
     * dataCollectionRules/{dcrName}.
     */
    private String defaultDataCollectionRuleResourceId;

    /**
     * Creates an instance of WorkspaceProperties class.
     */
    public WorkspaceProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the workspace.
     * 
     * @return the provisioningState value.
     */
    public WorkspaceEntityStatus provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the customerId property: This is a read-only property. Represents the ID associated with the workspace.
     * 
     * @return the customerId value.
     */
    public String customerId() {
        return this.customerId;
    }

    /**
     * Get the sku property: The SKU of the workspace.
     * 
     * @return the sku value.
     */
    public WorkspaceSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU of the workspace.
     * 
     * @param sku the sku value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties withSku(WorkspaceSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the retentionInDays property: The workspace data retention in days. Allowed values are per pricing plan. See
     * pricing tiers documentation for details.
     * 
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set the retentionInDays property: The workspace data retention in days. Allowed values are per pricing plan. See
     * pricing tiers documentation for details.
     * 
     * @param retentionInDays the retentionInDays value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Get the workspaceCapping property: The daily volume cap for ingestion.
     * 
     * @return the workspaceCapping value.
     */
    public WorkspaceCapping workspaceCapping() {
        return this.workspaceCapping;
    }

    /**
     * Set the workspaceCapping property: The daily volume cap for ingestion.
     * 
     * @param workspaceCapping the workspaceCapping value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties withWorkspaceCapping(WorkspaceCapping workspaceCapping) {
        this.workspaceCapping = workspaceCapping;
        return this;
    }

    /**
     * Get the createdDate property: Workspace creation date.
     * 
     * @return the createdDate value.
     */
    public String createdDate() {
        return this.createdDate;
    }

    /**
     * Get the modifiedDate property: Workspace modification date.
     * 
     * @return the modifiedDate value.
     */
    public String modifiedDate() {
        return this.modifiedDate;
    }

    /**
     * Get the publicNetworkAccessForIngestion property: The network access type for accessing Log Analytics ingestion.
     * 
     * @return the publicNetworkAccessForIngestion value.
     */
    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.publicNetworkAccessForIngestion;
    }

    /**
     * Set the publicNetworkAccessForIngestion property: The network access type for accessing Log Analytics ingestion.
     * 
     * @param publicNetworkAccessForIngestion the publicNetworkAccessForIngestion value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties
        withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        this.publicNetworkAccessForIngestion = publicNetworkAccessForIngestion;
        return this;
    }

    /**
     * Get the publicNetworkAccessForQuery property: The network access type for accessing Log Analytics query.
     * 
     * @return the publicNetworkAccessForQuery value.
     */
    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.publicNetworkAccessForQuery;
    }

    /**
     * Set the publicNetworkAccessForQuery property: The network access type for accessing Log Analytics query.
     * 
     * @param publicNetworkAccessForQuery the publicNetworkAccessForQuery value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        this.publicNetworkAccessForQuery = publicNetworkAccessForQuery;
        return this;
    }

    /**
     * Get the forceCmkForQuery property: Indicates whether customer managed storage is mandatory for query management.
     * 
     * @return the forceCmkForQuery value.
     */
    public Boolean forceCmkForQuery() {
        return this.forceCmkForQuery;
    }

    /**
     * Set the forceCmkForQuery property: Indicates whether customer managed storage is mandatory for query management.
     * 
     * @param forceCmkForQuery the forceCmkForQuery value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties withForceCmkForQuery(Boolean forceCmkForQuery) {
        this.forceCmkForQuery = forceCmkForQuery;
        return this;
    }

    /**
     * Get the privateLinkScopedResources property: List of linked private link scope resources.
     * 
     * @return the privateLinkScopedResources value.
     */
    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.privateLinkScopedResources;
    }

    /**
     * Get the features property: Workspace features.
     * 
     * @return the features value.
     */
    public WorkspaceFeatures features() {
        return this.features;
    }

    /**
     * Set the features property: Workspace features.
     * 
     * @param features the features value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties withFeatures(WorkspaceFeatures features) {
        this.features = features;
        return this;
    }

    /**
     * Get the defaultDataCollectionRuleResourceId property: The resource ID of the default Data Collection Rule to use
     * for this workspace. Expected format is -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
     * 
     * @return the defaultDataCollectionRuleResourceId value.
     */
    public String defaultDataCollectionRuleResourceId() {
        return this.defaultDataCollectionRuleResourceId;
    }

    /**
     * Set the defaultDataCollectionRuleResourceId property: The resource ID of the default Data Collection Rule to use
     * for this workspace. Expected format is -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
     * 
     * @param defaultDataCollectionRuleResourceId the defaultDataCollectionRuleResourceId value to set.
     * @return the WorkspaceProperties object itself.
     */
    public WorkspaceProperties withDefaultDataCollectionRuleResourceId(String defaultDataCollectionRuleResourceId) {
        this.defaultDataCollectionRuleResourceId = defaultDataCollectionRuleResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (workspaceCapping() != null) {
            workspaceCapping().validate();
        }
        if (privateLinkScopedResources() != null) {
            privateLinkScopedResources().forEach(e -> e.validate());
        }
        if (features() != null) {
            features().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeNumberField("retentionInDays", this.retentionInDays);
        jsonWriter.writeJsonField("workspaceCapping", this.workspaceCapping);
        jsonWriter.writeStringField("publicNetworkAccessForIngestion",
            this.publicNetworkAccessForIngestion == null ? null : this.publicNetworkAccessForIngestion.toString());
        jsonWriter.writeStringField("publicNetworkAccessForQuery",
            this.publicNetworkAccessForQuery == null ? null : this.publicNetworkAccessForQuery.toString());
        jsonWriter.writeBooleanField("forceCmkForQuery", this.forceCmkForQuery);
        jsonWriter.writeJsonField("features", this.features);
        jsonWriter.writeStringField("defaultDataCollectionRuleResourceId", this.defaultDataCollectionRuleResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkspaceProperties.
     */
    public static WorkspaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceProperties deserializedWorkspaceProperties = new WorkspaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkspaceProperties.provisioningState
                        = WorkspaceEntityStatus.fromString(reader.getString());
                } else if ("customerId".equals(fieldName)) {
                    deserializedWorkspaceProperties.customerId = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedWorkspaceProperties.sku = WorkspaceSku.fromJson(reader);
                } else if ("retentionInDays".equals(fieldName)) {
                    deserializedWorkspaceProperties.retentionInDays = reader.getNullable(JsonReader::getInt);
                } else if ("workspaceCapping".equals(fieldName)) {
                    deserializedWorkspaceProperties.workspaceCapping = WorkspaceCapping.fromJson(reader);
                } else if ("createdDate".equals(fieldName)) {
                    deserializedWorkspaceProperties.createdDate = reader.getString();
                } else if ("modifiedDate".equals(fieldName)) {
                    deserializedWorkspaceProperties.modifiedDate = reader.getString();
                } else if ("publicNetworkAccessForIngestion".equals(fieldName)) {
                    deserializedWorkspaceProperties.publicNetworkAccessForIngestion
                        = PublicNetworkAccessType.fromString(reader.getString());
                } else if ("publicNetworkAccessForQuery".equals(fieldName)) {
                    deserializedWorkspaceProperties.publicNetworkAccessForQuery
                        = PublicNetworkAccessType.fromString(reader.getString());
                } else if ("forceCmkForQuery".equals(fieldName)) {
                    deserializedWorkspaceProperties.forceCmkForQuery = reader.getNullable(JsonReader::getBoolean);
                } else if ("privateLinkScopedResources".equals(fieldName)) {
                    List<PrivateLinkScopedResource> privateLinkScopedResources
                        = reader.readArray(reader1 -> PrivateLinkScopedResource.fromJson(reader1));
                    deserializedWorkspaceProperties.privateLinkScopedResources = privateLinkScopedResources;
                } else if ("features".equals(fieldName)) {
                    deserializedWorkspaceProperties.features = WorkspaceFeatures.fromJson(reader);
                } else if ("defaultDataCollectionRuleResourceId".equals(fieldName)) {
                    deserializedWorkspaceProperties.defaultDataCollectionRuleResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceProperties;
        });
    }
}
