// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.fluent.IntelligencePacksClient;
import com.azure.resourcemanager.loganalytics.fluent.models.IntelligencePackInner;
import com.azure.resourcemanager.loganalytics.models.IntelligencePack;
import com.azure.resourcemanager.loganalytics.models.IntelligencePacks;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class IntelligencePacksImpl implements IntelligencePacks {
    private static final ClientLogger LOGGER = new ClientLogger(IntelligencePacksImpl.class);

    private final IntelligencePacksClient innerClient;

    private final com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager;

    public IntelligencePacksImpl(IntelligencePacksClient innerClient,
        com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Void> disableWithResponse(String resourceGroupName, String workspaceName,
        String intelligencePackName, Context context) {
        return this.serviceClient()
            .disableWithResponse(resourceGroupName, workspaceName, intelligencePackName, context);
    }

    public void disable(String resourceGroupName, String workspaceName, String intelligencePackName) {
        this.serviceClient().disable(resourceGroupName, workspaceName, intelligencePackName);
    }

    public Response<Void> enableWithResponse(String resourceGroupName, String workspaceName,
        String intelligencePackName, Context context) {
        return this.serviceClient().enableWithResponse(resourceGroupName, workspaceName, intelligencePackName, context);
    }

    public void enable(String resourceGroupName, String workspaceName, String intelligencePackName) {
        this.serviceClient().enable(resourceGroupName, workspaceName, intelligencePackName);
    }

    public Response<List<IntelligencePack>> listWithResponse(String resourceGroupName, String workspaceName,
        Context context) {
        Response<List<IntelligencePackInner>> inner
            = this.serviceClient().listWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                inner.getValue()
                    .stream()
                    .map(inner1 -> new IntelligencePackImpl(inner1, this.manager()))
                    .collect(Collectors.toList()));
        } else {
            return null;
        }
    }

    public List<IntelligencePack> list(String resourceGroupName, String workspaceName) {
        List<IntelligencePackInner> inner = this.serviceClient().list(resourceGroupName, workspaceName);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream()
                .map(inner1 -> new IntelligencePackImpl(inner1, this.manager()))
                .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    private IntelligencePacksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.loganalytics.LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}
