// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackInner;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPack;
import com.azure.resourcemanager.loganalytics.models.TagsResource;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class LogAnalyticsQueryPackImpl
    implements LogAnalyticsQueryPack, LogAnalyticsQueryPack.Definition, LogAnalyticsQueryPack.Update {
    private LogAnalyticsQueryPackInner innerObject;

    private final com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String queryPackId() {
        return this.innerModel().queryPackId();
    }

    public OffsetDateTime timeCreated() {
        return this.innerModel().timeCreated();
    }

    public OffsetDateTime timeModified() {
        return this.innerModel().timeModified();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public LogAnalyticsQueryPackInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.loganalytics.LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String queryPackName;

    private TagsResource updateQueryPackTags;

    public LogAnalyticsQueryPackImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public LogAnalyticsQueryPack create() {
        this.innerObject = serviceManager.serviceClient()
            .getQueryPacks()
            .createOrUpdateWithResponse(resourceGroupName, queryPackName, this.innerModel(), Context.NONE)
            .getValue();
        return this;
    }

    public LogAnalyticsQueryPack create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getQueryPacks()
            .createOrUpdateWithResponse(resourceGroupName, queryPackName, this.innerModel(), context)
            .getValue();
        return this;
    }

    LogAnalyticsQueryPackImpl(String name, com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerObject = new LogAnalyticsQueryPackInner();
        this.serviceManager = serviceManager;
        this.queryPackName = name;
    }

    public LogAnalyticsQueryPackImpl update() {
        this.updateQueryPackTags = new TagsResource();
        return this;
    }

    public LogAnalyticsQueryPack apply() {
        this.innerObject = serviceManager.serviceClient()
            .getQueryPacks()
            .updateTagsWithResponse(resourceGroupName, queryPackName, updateQueryPackTags, Context.NONE)
            .getValue();
        return this;
    }

    public LogAnalyticsQueryPack apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getQueryPacks()
            .updateTagsWithResponse(resourceGroupName, queryPackName, updateQueryPackTags, context)
            .getValue();
        return this;
    }

    LogAnalyticsQueryPackImpl(LogAnalyticsQueryPackInner innerObject,
        com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.queryPackName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "queryPacks");
    }

    public LogAnalyticsQueryPack refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getQueryPacks()
            .getByResourceGroupWithResponse(resourceGroupName, queryPackName, Context.NONE)
            .getValue();
        return this;
    }

    public LogAnalyticsQueryPack refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getQueryPacks()
            .getByResourceGroupWithResponse(resourceGroupName, queryPackName, context)
            .getValue();
        return this;
    }

    public LogAnalyticsQueryPackImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public LogAnalyticsQueryPackImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public LogAnalyticsQueryPackImpl withTags(Map<String, String> tags) {
        if (isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        } else {
            this.updateQueryPackTags.withTags(tags);
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
