// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.loganalytics.fluent.QueriesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackQueryInner;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQueryListResult;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQuerySearchProperties;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in QueriesClient.
 */
public final class QueriesClientImpl implements QueriesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final QueriesService service;

    /**
     * The service client containing this operation class.
     */
    private final OperationalInsightsManagementClientImpl client;

    /**
     * Initializes an instance of QueriesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    QueriesClientImpl(OperationalInsightsManagementClientImpl client) {
        this.service = RestProxy.create(QueriesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for OperationalInsightsManagementClientQueries to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "OperationalInsightsM")
    public interface QueriesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogAnalyticsQueryPackQueryListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("queryPackName") String queryPackName,
            @QueryParam("api-version") String apiVersion, @QueryParam("$top") Long top,
            @QueryParam("includeBody") Boolean includeBody, @QueryParam("$skipToken") String skipToken,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/search")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogAnalyticsQueryPackQueryListResult>> search(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("queryPackName") String queryPackName,
            @QueryParam("api-version") String apiVersion, @QueryParam("$top") Long top,
            @QueryParam("includeBody") Boolean includeBody, @QueryParam("$skipToken") String skipToken,
            @BodyParam("application/json") LogAnalyticsQueryPackQuerySearchProperties querySearchProperties,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogAnalyticsQueryPackQueryInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("queryPackName") String queryPackName,
            @PathParam("id") String id, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogAnalyticsQueryPackQueryInner>> put(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("queryPackName") String queryPackName,
            @PathParam("id") String id, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") LogAnalyticsQueryPackQueryInner queryPayload,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogAnalyticsQueryPackQueryInner>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("queryPackName") String queryPackName,
            @PathParam("id") String id, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") LogAnalyticsQueryPackQueryInner queryPayload,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("queryPackName") String queryPackName,
            @PathParam("id") String id, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogAnalyticsQueryPackQueryListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogAnalyticsQueryPackQueryListResult>> searchNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listSinglePageAsync(String resourceGroupName,
        String queryPackName, Long top, Boolean includeBody, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, queryPackName, apiVersion, top, includeBody, skipToken, accept, context))
            .<PagedResponse<LogAnalyticsQueryPackQueryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listSinglePageAsync(String resourceGroupName,
        String queryPackName, Long top, Boolean includeBody, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName,
                apiVersion, top, includeBody, skipToken, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> listAsync(String resourceGroupName, String queryPackName,
        Long top, Boolean includeBody, String skipToken) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, queryPackName, top, includeBody, skipToken),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> listAsync(String resourceGroupName, String queryPackName) {
        final Long top = null;
        final Boolean includeBody = null;
        final String skipToken = null;
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, queryPackName, top, includeBody, skipToken),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> listAsync(String resourceGroupName, String queryPackName,
        Long top, Boolean includeBody, String skipToken, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, queryPackName, top, includeBody, skipToken, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> list(String resourceGroupName, String queryPackName) {
        final Long top = null;
        final Boolean includeBody = null;
        final String skipToken = null;
        return new PagedIterable<>(listAsync(resourceGroupName, queryPackName, top, includeBody, skipToken));
    }

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> list(String resourceGroupName, String queryPackName, Long top,
        Boolean includeBody, String skipToken, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, queryPackName, top, includeBody, skipToken, context));
    }

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchSinglePageAsync(String resourceGroupName,
        String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top,
        Boolean includeBody, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (querySearchProperties == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter querySearchProperties is required and cannot be null."));
        } else {
            querySearchProperties.validate();
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.search(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    queryPackName, apiVersion, top, includeBody, skipToken, querySearchProperties, accept, context))
            .<PagedResponse<LogAnalyticsQueryPackQueryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchSinglePageAsync(String resourceGroupName,
        String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top,
        Boolean includeBody, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (querySearchProperties == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter querySearchProperties is required and cannot be null."));
        } else {
            querySearchProperties.validate();
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .search(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName,
                apiVersion, top, includeBody, skipToken, querySearchProperties, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> searchAsync(String resourceGroupName, String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody,
        String skipToken) {
        return new PagedFlux<>(() -> searchSinglePageAsync(resourceGroupName, queryPackName, querySearchProperties, top,
            includeBody, skipToken), nextLink -> searchNextSinglePageAsync(nextLink));
    }

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> searchAsync(String resourceGroupName, String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties) {
        final Long top = null;
        final Boolean includeBody = null;
        final String skipToken = null;
        return new PagedFlux<>(() -> searchSinglePageAsync(resourceGroupName, queryPackName, querySearchProperties, top,
            includeBody, skipToken), nextLink -> searchNextSinglePageAsync(nextLink));
    }

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> searchAsync(String resourceGroupName, String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody,
        String skipToken, Context context) {
        return new PagedFlux<>(() -> searchSinglePageAsync(resourceGroupName, queryPackName, querySearchProperties, top,
            includeBody, skipToken, context), nextLink -> searchNextSinglePageAsync(nextLink, context));
    }

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> search(String resourceGroupName, String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties) {
        final Long top = null;
        final Boolean includeBody = null;
        final String skipToken = null;
        return new PagedIterable<>(
            searchAsync(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken));
    }

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     * return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> search(String resourceGroupName, String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody,
        String skipToken, Context context) {
        return new PagedIterable<>(
            searchAsync(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken, context));
    }

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> getWithResponseAsync(String resourceGroupName,
        String queryPackName, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, queryPackName, id, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> getWithResponseAsync(String resourceGroupName,
        String queryPackName, String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName,
            id, apiVersion, accept, context);
    }

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<LogAnalyticsQueryPackQueryInner> getAsync(String resourceGroupName, String queryPackName, String id) {
        return getWithResponseAsync(resourceGroupName, queryPackName, id)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LogAnalyticsQueryPackQueryInner> getWithResponse(String resourceGroupName, String queryPackName,
        String id, Context context) {
        return getWithResponseAsync(resourceGroupName, queryPackName, id, context).block();
    }

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LogAnalyticsQueryPackQueryInner get(String resourceGroupName, String queryPackName, String id) {
        return getWithResponse(resourceGroupName, queryPackName, id, Context.NONE).getValue();
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> putWithResponseAsync(String resourceGroupName,
        String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        } else {
            queryPayload.validate();
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.put(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, queryPackName, id, apiVersion, queryPayload, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> putWithResponseAsync(String resourceGroupName,
        String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        } else {
            queryPayload.validate();
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.put(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName,
            id, apiVersion, queryPayload, accept, context);
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<LogAnalyticsQueryPackQueryInner> putAsync(String resourceGroupName, String queryPackName, String id,
        LogAnalyticsQueryPackQueryInner queryPayload) {
        return putWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LogAnalyticsQueryPackQueryInner> putWithResponse(String resourceGroupName, String queryPackName,
        String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        return putWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload, context).block();
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LogAnalyticsQueryPackQueryInner put(String resourceGroupName, String queryPackName, String id,
        LogAnalyticsQueryPackQueryInner queryPayload) {
        return putWithResponse(resourceGroupName, queryPackName, id, queryPayload, Context.NONE).getValue();
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> updateWithResponseAsync(String resourceGroupName,
        String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        } else {
            queryPayload.validate();
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, queryPackName, id, apiVersion, queryPayload, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> updateWithResponseAsync(String resourceGroupName,
        String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        } else {
            queryPayload.validate();
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            queryPackName, id, apiVersion, queryPayload, accept, context);
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<LogAnalyticsQueryPackQueryInner> updateAsync(String resourceGroupName, String queryPackName, String id,
        LogAnalyticsQueryPackQueryInner queryPayload) {
        return updateWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LogAnalyticsQueryPackQueryInner> updateWithResponse(String resourceGroupName, String queryPackName,
        String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        return updateWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload, context).block();
    }

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     * QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LogAnalyticsQueryPackQueryInner update(String resourceGroupName, String queryPackName, String id,
        LogAnalyticsQueryPackQueryInner queryPayload) {
        return updateWithResponse(resourceGroupName, queryPackName, id, queryPayload, Context.NONE).getValue();
    }

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String queryPackName, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, queryPackName, id, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String queryPackName, String id,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error(new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error(new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        final String apiVersion = "2019-09-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            queryPackName, id, apiVersion, accept, context);
    }

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String queryPackName, String id) {
        return deleteWithResponseAsync(resourceGroupName, queryPackName, id).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String queryPackName, String id,
        Context context) {
        return deleteWithResponseAsync(resourceGroupName, queryPackName, id, context).block();
    }

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String queryPackName, String id) {
        deleteWithResponse(resourceGroupName, queryPackName, id, Context.NONE);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LogAnalyticsQueryPackQueryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.searchNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LogAnalyticsQueryPackQueryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.searchNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
