// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An Azure resource QueryPack-Query object.
 */
@Immutable
public class AzureResourceProperties implements JsonSerializable<AzureResourceProperties> {
    /*
     * Azure resource Id
     */
    private String id;

    /*
     * Azure resource name
     */
    private String name;

    /*
     * Azure resource type
     */
    private String type;

    /*
     * Read only system data
     */
    private SystemData systemData;

    /**
     * Creates an instance of AzureResourceProperties class.
     */
    public AzureResourceProperties() {
    }

    /**
     * Get the id property: Azure resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Azure resource Id.
     * 
     * @param id the id value to set.
     * @return the AzureResourceProperties object itself.
     */
    AzureResourceProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Azure resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Azure resource name.
     * 
     * @param name the name value to set.
     * @return the AzureResourceProperties object itself.
     */
    AzureResourceProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Azure resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Azure resource type.
     * 
     * @param type the type value to set.
     * @return the AzureResourceProperties object itself.
     */
    AzureResourceProperties withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the systemData property: Read only system data.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Set the systemData property: Read only system data.
     * 
     * @param systemData the systemData value to set.
     * @return the AzureResourceProperties object itself.
     */
    AzureResourceProperties withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureResourceProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureResourceProperties.
     */
    public static AzureResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureResourceProperties deserializedAzureResourceProperties = new AzureResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAzureResourceProperties.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAzureResourceProperties.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAzureResourceProperties.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedAzureResourceProperties.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureResourceProperties;
        });
    }
}
