// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

/**
 * The capacity reservation level in Gigabytes for this cluster.
 */
public enum Capacity {
    /**
     * Enum value 100.
     */
    ONE_ZERO_ZERO(100L),

    /**
     * Enum value 200.
     */
    TWO_ZERO_ZERO(200L),

    /**
     * Enum value 300.
     */
    THREE_ZERO_ZERO(300L),

    /**
     * Enum value 400.
     */
    FOUR_ZERO_ZERO(400L),

    /**
     * Enum value 500.
     */
    FIVE_ZERO_ZERO(500L),

    /**
     * Enum value 1000.
     */
    ONE_ZERO_ZERO_ZERO(1000L),

    /**
     * Enum value 2000.
     */
    TWO_ZERO_ZERO_ZERO(2000L),

    /**
     * Enum value 5000.
     */
    FIVE_ZERO_ZERO_ZERO(5000L),

    /**
     * Enum value 10000.
     */
    ONE_ZERO_ZERO_ZERO_ZERO(10000L),

    /**
     * Enum value 25000.
     */
    TWO_FIVE_ZERO_ZERO_ZERO(25000L),

    /**
     * Enum value 50000.
     */
    FIVE_ZERO_ZERO_ZERO_ZERO(50000L);

    /**
     * The actual serialized value for a Capacity instance.
     */
    private final long value;

    Capacity(long value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a Capacity instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed Capacity object, or null if unable to parse.
     */
    public static Capacity fromLong(long value) {
        Capacity[] items = Capacity.values();
        for (Capacity item : items) {
            if (item.toLong() == value) {
                return item;
            }
        }
        return null;
    }

    /**
     * De-serializes the instance to long value.
     * 
     * @return the long value.
     */
    public long toLong() {
        return this.value;
    }
}
