// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

/**
 * The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
 */
public enum CapacityReservationLevel {
    /**
     * Enum value 100.
     */
    ONE_ZERO_ZERO(100),

    /**
     * Enum value 200.
     */
    TWO_ZERO_ZERO(200),

    /**
     * Enum value 300.
     */
    THREE_ZERO_ZERO(300),

    /**
     * Enum value 400.
     */
    FOUR_ZERO_ZERO(400),

    /**
     * Enum value 500.
     */
    FIVE_ZERO_ZERO(500),

    /**
     * Enum value 1000.
     */
    ONE_ZERO_ZERO_ZERO(1000),

    /**
     * Enum value 2000.
     */
    TWO_ZERO_ZERO_ZERO(2000),

    /**
     * Enum value 5000.
     */
    FIVE_ZERO_ZERO_ZERO(5000);

    /**
     * The actual serialized value for a CapacityReservationLevel instance.
     */
    private final int value;

    CapacityReservationLevel(int value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CapacityReservationLevel instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CapacityReservationLevel object, or null if unable to parse.
     */
    public static CapacityReservationLevel fromInt(int value) {
        CapacityReservationLevel[] items = CapacityReservationLevel.values();
        for (CapacityReservationLevel item : items) {
            if (item.toInt() == value) {
                return item;
            }
        }
        return null;
    }

    /**
     * De-serializes the instance to int value.
     * 
     * @return the int value.
     */
    public int toInt() {
        return this.value;
    }
}
