// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.ClusterPatchProperties;
import java.io.IOException;
import java.util.Map;

/**
 * The top level Log Analytics cluster resource container.
 */
@Fluent
public final class ClusterPatch implements JsonSerializable<ClusterPatch> {
    /*
     * Log Analytics cluster properties.
     */
    private ClusterPatchProperties innerProperties;

    /*
     * Resource's identity.
     */
    private ManagedServiceIdentity identity;

    /*
     * The sku properties.
     */
    private ClusterSku sku;

    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of ClusterPatch class.
     */
    public ClusterPatch() {
    }

    /**
     * Get the innerProperties property: Log Analytics cluster properties.
     * 
     * @return the innerProperties value.
     */
    private ClusterPatchProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the identity property: Resource's identity.
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Resource's identity.
     * 
     * @param identity the identity value to set.
     * @return the ClusterPatch object itself.
     */
    public ClusterPatch withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the sku property: The sku properties.
     * 
     * @return the sku value.
     */
    public ClusterSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The sku properties.
     * 
     * @param sku the sku value to set.
     * @return the ClusterPatch object itself.
     */
    public ClusterPatch withSku(ClusterSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the ClusterPatch object itself.
     */
    public ClusterPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the keyVaultProperties property: The associated key properties.
     * 
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultProperties();
    }

    /**
     * Set the keyVaultProperties property: The associated key properties.
     * 
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the ClusterPatch object itself.
     */
    public ClusterPatch withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    /**
     * Get the billingType property: The cluster's billing type.
     * 
     * @return the billingType value.
     */
    public BillingType billingType() {
        return this.innerProperties() == null ? null : this.innerProperties().billingType();
    }

    /**
     * Set the billingType property: The cluster's billing type.
     * 
     * @param billingType the billingType value to set.
     * @return the ClusterPatch object itself.
     */
    public ClusterPatch withBillingType(BillingType billingType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withBillingType(billingType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClusterPatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClusterPatch if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClusterPatch.
     */
    public static ClusterPatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterPatch deserializedClusterPatch = new ClusterPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedClusterPatch.innerProperties = ClusterPatchProperties.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedClusterPatch.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedClusterPatch.sku = ClusterSku.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterPatch.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClusterPatch;
        });
    }
}
