// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The cluster sku definition.
 */
@Fluent
public final class ClusterSku implements JsonSerializable<ClusterSku> {
    /*
     * The capacity reservation level in Gigabytes for this cluster.
     */
    private Capacity capacity;

    /*
     * The SKU (tier) of a cluster.
     */
    private ClusterSkuNameEnum name;

    /**
     * Creates an instance of ClusterSku class.
     */
    public ClusterSku() {
    }

    /**
     * Get the capacity property: The capacity reservation level in Gigabytes for this cluster.
     * 
     * @return the capacity value.
     */
    public Capacity capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: The capacity reservation level in Gigabytes for this cluster.
     * 
     * @param capacity the capacity value to set.
     * @return the ClusterSku object itself.
     */
    public ClusterSku withCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Get the name property: The SKU (tier) of a cluster.
     * 
     * @return the name value.
     */
    public ClusterSkuNameEnum name() {
        return this.name;
    }

    /**
     * Set the name property: The SKU (tier) of a cluster.
     * 
     * @param name the name value to set.
     * @return the ClusterSku object itself.
     */
    public ClusterSku withName(ClusterSkuNameEnum name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("capacity", this.capacity == null ? null : this.capacity.toLong());
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClusterSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClusterSku if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the ClusterSku.
     */
    public static ClusterSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterSku deserializedClusterSku = new ClusterSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("capacity".equals(fieldName)) {
                    deserializedClusterSku.capacity = Capacity.fromLong(reader.getLong());
                } else if ("name".equals(fieldName)) {
                    deserializedClusterSku.name = ClusterSkuNameEnum.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClusterSku;
        });
    }
}
