// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Table column.
 */
@Fluent
public final class Column implements JsonSerializable<Column> {
    /*
     * Column name.
     */
    private String name;

    /*
     * Column data type.
     */
    private ColumnTypeEnum type;

    /*
     * Column data type logical hint.
     */
    private ColumnDataTypeHintEnum dataTypeHint;

    /*
     * Column display name.
     */
    private String displayName;

    /*
     * Column description.
     */
    private String description;

    /*
     * Is displayed by default.
     */
    private Boolean isDefaultDisplay;

    /*
     * Is column hidden.
     */
    private Boolean isHidden;

    /**
     * Creates an instance of Column class.
     */
    public Column() {
    }

    /**
     * Get the name property: Column name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Column name.
     * 
     * @param name the name value to set.
     * @return the Column object itself.
     */
    public Column withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Column data type.
     * 
     * @return the type value.
     */
    public ColumnTypeEnum type() {
        return this.type;
    }

    /**
     * Set the type property: Column data type.
     * 
     * @param type the type value to set.
     * @return the Column object itself.
     */
    public Column withType(ColumnTypeEnum type) {
        this.type = type;
        return this;
    }

    /**
     * Get the dataTypeHint property: Column data type logical hint.
     * 
     * @return the dataTypeHint value.
     */
    public ColumnDataTypeHintEnum dataTypeHint() {
        return this.dataTypeHint;
    }

    /**
     * Set the dataTypeHint property: Column data type logical hint.
     * 
     * @param dataTypeHint the dataTypeHint value to set.
     * @return the Column object itself.
     */
    public Column withDataTypeHint(ColumnDataTypeHintEnum dataTypeHint) {
        this.dataTypeHint = dataTypeHint;
        return this;
    }

    /**
     * Get the displayName property: Column display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Column display name.
     * 
     * @param displayName the displayName value to set.
     * @return the Column object itself.
     */
    public Column withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: Column description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Column description.
     * 
     * @param description the description value to set.
     * @return the Column object itself.
     */
    public Column withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the isDefaultDisplay property: Is displayed by default.
     * 
     * @return the isDefaultDisplay value.
     */
    public Boolean isDefaultDisplay() {
        return this.isDefaultDisplay;
    }

    /**
     * Get the isHidden property: Is column hidden.
     * 
     * @return the isHidden value.
     */
    public Boolean isHidden() {
        return this.isHidden;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("dataTypeHint", this.dataTypeHint == null ? null : this.dataTypeHint.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Column from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Column if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Column.
     */
    public static Column fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Column deserializedColumn = new Column();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedColumn.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedColumn.type = ColumnTypeEnum.fromString(reader.getString());
                } else if ("dataTypeHint".equals(fieldName)) {
                    deserializedColumn.dataTypeHint = ColumnDataTypeHintEnum.fromString(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedColumn.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedColumn.description = reader.getString();
                } else if ("isDefaultDisplay".equals(fieldName)) {
                    deserializedColumn.isDefaultDisplay = reader.getNullable(JsonReader::getBoolean);
                } else if ("isHidden".equals(fieldName)) {
                    deserializedColumn.isHidden = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedColumn;
        });
    }
}
