// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.DataExportInner;
import java.util.List;

/**
 * An immutable client-side representation of DataExport.
 */
public interface DataExport {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the dataExportId property: The data export rule ID.
     * 
     * @return the dataExportId value.
     */
    String dataExportId();

    /**
     * Gets the tableNames property: An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     * 
     * @return the tableNames value.
     */
    List<String> tableNames();

    /**
     * Gets the enable property: Active when enabled.
     * 
     * @return the enable value.
     */
    Boolean enable();

    /**
     * Gets the createdDate property: The latest data export rule modification time.
     * 
     * @return the createdDate value.
     */
    String createdDate();

    /**
     * Gets the lastModifiedDate property: Date and time when the export was last modified.
     * 
     * @return the lastModifiedDate value.
     */
    String lastModifiedDate();

    /**
     * Gets the resourceId property: The destination resource ID. This can be copied from the Properties entry of the
     * destination resource in Azure.
     * 
     * @return the resourceId value.
     */
    String resourceId();

    /**
     * Gets the typePropertiesType property: The type of the destination resource.
     * 
     * @return the typePropertiesType value.
     */
    Type typePropertiesType();

    /**
     * Gets the eventHubName property: Optional. Allows to define an Event Hub name. Not applicable when destination is
     * Storage Account.
     * 
     * @return the eventHubName value.
     */
    String eventHubName();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.loganalytics.fluent.models.DataExportInner object.
     * 
     * @return the inner object.
     */
    DataExportInner innerModel();

    /**
     * The entirety of the DataExport definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The DataExport definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the DataExport definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the DataExport definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, workspaceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param workspaceName The name of the workspace.
             * @return the next definition stage.
             */
            WithCreate withExistingWorkspace(String resourceGroupName, String workspaceName);
        }

        /**
         * The stage of the DataExport definition which contains all the minimum required properties for the resource to
         * be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithDataExportId, DefinitionStages.WithTableNames,
            DefinitionStages.WithEnable, DefinitionStages.WithCreatedDate, DefinitionStages.WithLastModifiedDate,
            DefinitionStages.WithResourceId, DefinitionStages.WithEventHubName {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            DataExport create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            DataExport create(Context context);
        }

        /**
         * The stage of the DataExport definition allowing to specify dataExportId.
         */
        interface WithDataExportId {
            /**
             * Specifies the dataExportId property: The data export rule ID..
             * 
             * @param dataExportId The data export rule ID.
             * @return the next definition stage.
             */
            WithCreate withDataExportId(String dataExportId);
        }

        /**
         * The stage of the DataExport definition allowing to specify tableNames.
         */
        interface WithTableNames {
            /**
             * Specifies the tableNames property: An array of tables to export, for example: [“Heartbeat,
             * SecurityEvent”]..
             * 
             * @param tableNames An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
             * @return the next definition stage.
             */
            WithCreate withTableNames(List<String> tableNames);
        }

        /**
         * The stage of the DataExport definition allowing to specify enable.
         */
        interface WithEnable {
            /**
             * Specifies the enable property: Active when enabled..
             * 
             * @param enable Active when enabled.
             * @return the next definition stage.
             */
            WithCreate withEnable(Boolean enable);
        }

        /**
         * The stage of the DataExport definition allowing to specify createdDate.
         */
        interface WithCreatedDate {
            /**
             * Specifies the createdDate property: The latest data export rule modification time..
             * 
             * @param createdDate The latest data export rule modification time.
             * @return the next definition stage.
             */
            WithCreate withCreatedDate(String createdDate);
        }

        /**
         * The stage of the DataExport definition allowing to specify lastModifiedDate.
         */
        interface WithLastModifiedDate {
            /**
             * Specifies the lastModifiedDate property: Date and time when the export was last modified..
             * 
             * @param lastModifiedDate Date and time when the export was last modified.
             * @return the next definition stage.
             */
            WithCreate withLastModifiedDate(String lastModifiedDate);
        }

        /**
         * The stage of the DataExport definition allowing to specify resourceId.
         */
        interface WithResourceId {
            /**
             * Specifies the resourceId property: The destination resource ID. This can be copied from the Properties
             * entry of the destination resource in Azure..
             * 
             * @param resourceId The destination resource ID. This can be copied from the Properties entry of the
             * destination resource in Azure.
             * @return the next definition stage.
             */
            WithCreate withResourceId(String resourceId);
        }

        /**
         * The stage of the DataExport definition allowing to specify eventHubName.
         */
        interface WithEventHubName {
            /**
             * Specifies the eventHubName property: Optional. Allows to define an Event Hub name. Not applicable when
             * destination is Storage Account..
             * 
             * @param eventHubName Optional. Allows to define an Event Hub name. Not applicable when destination is
             * Storage Account.
             * @return the next definition stage.
             */
            WithCreate withEventHubName(String eventHubName);
        }
    }

    /**
     * Begins update for the DataExport resource.
     * 
     * @return the stage of resource update.
     */
    DataExport.Update update();

    /**
     * The template for DataExport update.
     */
    interface Update extends UpdateStages.WithDataExportId, UpdateStages.WithTableNames, UpdateStages.WithEnable,
        UpdateStages.WithCreatedDate, UpdateStages.WithLastModifiedDate, UpdateStages.WithResourceId,
        UpdateStages.WithEventHubName {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        DataExport apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        DataExport apply(Context context);
    }

    /**
     * The DataExport update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the DataExport update allowing to specify dataExportId.
         */
        interface WithDataExportId {
            /**
             * Specifies the dataExportId property: The data export rule ID..
             * 
             * @param dataExportId The data export rule ID.
             * @return the next definition stage.
             */
            Update withDataExportId(String dataExportId);
        }

        /**
         * The stage of the DataExport update allowing to specify tableNames.
         */
        interface WithTableNames {
            /**
             * Specifies the tableNames property: An array of tables to export, for example: [“Heartbeat,
             * SecurityEvent”]..
             * 
             * @param tableNames An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
             * @return the next definition stage.
             */
            Update withTableNames(List<String> tableNames);
        }

        /**
         * The stage of the DataExport update allowing to specify enable.
         */
        interface WithEnable {
            /**
             * Specifies the enable property: Active when enabled..
             * 
             * @param enable Active when enabled.
             * @return the next definition stage.
             */
            Update withEnable(Boolean enable);
        }

        /**
         * The stage of the DataExport update allowing to specify createdDate.
         */
        interface WithCreatedDate {
            /**
             * Specifies the createdDate property: The latest data export rule modification time..
             * 
             * @param createdDate The latest data export rule modification time.
             * @return the next definition stage.
             */
            Update withCreatedDate(String createdDate);
        }

        /**
         * The stage of the DataExport update allowing to specify lastModifiedDate.
         */
        interface WithLastModifiedDate {
            /**
             * Specifies the lastModifiedDate property: Date and time when the export was last modified..
             * 
             * @param lastModifiedDate Date and time when the export was last modified.
             * @return the next definition stage.
             */
            Update withLastModifiedDate(String lastModifiedDate);
        }

        /**
         * The stage of the DataExport update allowing to specify resourceId.
         */
        interface WithResourceId {
            /**
             * Specifies the resourceId property: The destination resource ID. This can be copied from the Properties
             * entry of the destination resource in Azure..
             * 
             * @param resourceId The destination resource ID. This can be copied from the Properties entry of the
             * destination resource in Azure.
             * @return the next definition stage.
             */
            Update withResourceId(String resourceId);
        }

        /**
         * The stage of the DataExport update allowing to specify eventHubName.
         */
        interface WithEventHubName {
            /**
             * Specifies the eventHubName property: Optional. Allows to define an Event Hub name. Not applicable when
             * destination is Storage Account..
             * 
             * @param eventHubName Optional. Allows to define an Event Hub name. Not applicable when destination is
             * Storage Account.
             * @return the next definition stage.
             */
            Update withEventHubName(String eventHubName);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    DataExport refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    DataExport refresh(Context context);
}
