// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.DataExportInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list data exports.
 */
@Fluent
public final class DataExportListResult implements JsonSerializable<DataExportListResult> {
    /*
     * List of data export instances within a workspace..
     */
    private List<DataExportInner> value;

    /**
     * Creates an instance of DataExportListResult class.
     */
    public DataExportListResult() {
    }

    /**
     * Get the value property: List of data export instances within a workspace..
     * 
     * @return the value value.
     */
    public List<DataExportInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of data export instances within a workspace..
     * 
     * @param value the value value to set.
     * @return the DataExportListResult object itself.
     */
    public DataExportListResult withValue(List<DataExportInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataExportListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataExportListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataExportListResult.
     */
    public static DataExportListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataExportListResult deserializedDataExportListResult = new DataExportListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DataExportInner> value = reader.readArray(reader1 -> DataExportInner.fromJson(reader1));
                    deserializedDataExportListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataExportListResult;
        });
    }
}
