// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.DataSourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The list data source by workspace operation response.
 */
@Fluent
public final class DataSourceListResult implements JsonSerializable<DataSourceListResult> {
    /*
     * A list of datasources.
     */
    private List<DataSourceInner> value;

    /*
     * The link (url) to the next page of datasources.
     */
    private String nextLink;

    /**
     * Creates an instance of DataSourceListResult class.
     */
    public DataSourceListResult() {
    }

    /**
     * Get the value property: A list of datasources.
     * 
     * @return the value value.
     */
    public List<DataSourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of datasources.
     * 
     * @param value the value value to set.
     * @return the DataSourceListResult object itself.
     */
    public DataSourceListResult withValue(List<DataSourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link (url) to the next page of datasources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link (url) to the next page of datasources.
     * 
     * @param nextLink the nextLink value to set.
     * @return the DataSourceListResult object itself.
     */
    public DataSourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataSourceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataSourceListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataSourceListResult.
     */
    public static DataSourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataSourceListResult deserializedDataSourceListResult = new DataSourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DataSourceInner> value = reader.readArray(reader1 -> DataSourceInner.fromJson(reader1));
                    deserializedDataSourceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDataSourceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataSourceListResult;
        });
    }
}
