// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The key vault properties.
 */
@Fluent
public final class KeyVaultProperties implements JsonSerializable<KeyVaultProperties> {
    /*
     * The Key Vault uri which holds they key associated with the Log Analytics cluster.
     */
    private String keyVaultUri;

    /*
     * The name of the key associated with the Log Analytics cluster.
     */
    private String keyName;

    /*
     * The version of the key associated with the Log Analytics cluster.
     */
    private String keyVersion;

    /*
     * Selected key minimum required size.
     */
    private Integer keyRsaSize;

    /**
     * Creates an instance of KeyVaultProperties class.
     */
    public KeyVaultProperties() {
    }

    /**
     * Get the keyVaultUri property: The Key Vault uri which holds they key associated with the Log Analytics cluster.
     * 
     * @return the keyVaultUri value.
     */
    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    /**
     * Set the keyVaultUri property: The Key Vault uri which holds they key associated with the Log Analytics cluster.
     * 
     * @param keyVaultUri the keyVaultUri value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    /**
     * Get the keyName property: The name of the key associated with the Log Analytics cluster.
     * 
     * @return the keyName value.
     */
    public String keyName() {
        return this.keyName;
    }

    /**
     * Set the keyName property: The name of the key associated with the Log Analytics cluster.
     * 
     * @param keyName the keyName value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    /**
     * Get the keyVersion property: The version of the key associated with the Log Analytics cluster.
     * 
     * @return the keyVersion value.
     */
    public String keyVersion() {
        return this.keyVersion;
    }

    /**
     * Set the keyVersion property: The version of the key associated with the Log Analytics cluster.
     * 
     * @param keyVersion the keyVersion value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    /**
     * Get the keyRsaSize property: Selected key minimum required size.
     * 
     * @return the keyRsaSize value.
     */
    public Integer keyRsaSize() {
        return this.keyRsaSize;
    }

    /**
     * Set the keyRsaSize property: Selected key minimum required size.
     * 
     * @param keyRsaSize the keyRsaSize value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyRsaSize(Integer keyRsaSize) {
        this.keyRsaSize = keyRsaSize;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultUri", this.keyVaultUri);
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeStringField("keyVersion", this.keyVersion);
        jsonWriter.writeNumberField("keyRsaSize", this.keyRsaSize);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyVaultProperties.
     */
    public static KeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultProperties deserializedKeyVaultProperties = new KeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyVaultUri".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVaultUri = reader.getString();
                } else if ("keyName".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyName = reader.getString();
                } else if ("keyVersion".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVersion = reader.getString();
                } else if ("keyRsaSize".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyRsaSize = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultProperties;
        });
    }
}
