// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedServiceInner;
import java.io.IOException;
import java.util.List;

/**
 * The list linked service operation response.
 */
@Fluent
public final class LinkedServiceListResult implements JsonSerializable<LinkedServiceListResult> {
    /*
     * The list of linked service instances
     */
    private List<LinkedServiceInner> value;

    /**
     * Creates an instance of LinkedServiceListResult class.
     */
    public LinkedServiceListResult() {
    }

    /**
     * Get the value property: The list of linked service instances.
     * 
     * @return the value value.
     */
    public List<LinkedServiceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of linked service instances.
     * 
     * @param value the value value to set.
     * @return the LinkedServiceListResult object itself.
     */
    public LinkedServiceListResult withValue(List<LinkedServiceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LinkedServiceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LinkedServiceListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LinkedServiceListResult.
     */
    public static LinkedServiceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LinkedServiceListResult deserializedLinkedServiceListResult = new LinkedServiceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<LinkedServiceInner> value = reader.readArray(reader1 -> LinkedServiceInner.fromJson(reader1));
                    deserializedLinkedServiceListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLinkedServiceListResult;
        });
    }
}
