// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedStorageAccountsResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The list linked storage accounts service operation response.
 */
@Fluent
public final class LinkedStorageAccountsListResult implements JsonSerializable<LinkedStorageAccountsListResult> {
    /*
     * A list of linked storage accounts instances.
     */
    private List<LinkedStorageAccountsResourceInner> value;

    /**
     * Creates an instance of LinkedStorageAccountsListResult class.
     */
    public LinkedStorageAccountsListResult() {
    }

    /**
     * Get the value property: A list of linked storage accounts instances.
     * 
     * @return the value value.
     */
    public List<LinkedStorageAccountsResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of linked storage accounts instances.
     * 
     * @param value the value value to set.
     * @return the LinkedStorageAccountsListResult object itself.
     */
    public LinkedStorageAccountsListResult withValue(List<LinkedStorageAccountsResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LinkedStorageAccountsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LinkedStorageAccountsListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LinkedStorageAccountsListResult.
     */
    public static LinkedStorageAccountsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LinkedStorageAccountsListResult deserializedLinkedStorageAccountsListResult
                = new LinkedStorageAccountsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<LinkedStorageAccountsResourceInner> value
                        = reader.readArray(reader1 -> LinkedStorageAccountsResourceInner.fromJson(reader1));
                    deserializedLinkedStorageAccountsListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLinkedStorageAccountsListResult;
        });
    }
}
