// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The name of a metric.
 */
@Fluent
public final class MetricName implements JsonSerializable<MetricName> {
    /*
     * The system name of the metric.
     */
    private String value;

    /*
     * The localized name of the metric.
     */
    private String localizedValue;

    /**
     * Creates an instance of MetricName class.
     */
    public MetricName() {
    }

    /**
     * Get the value property: The system name of the metric.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The system name of the metric.
     * 
     * @param value the value value to set.
     * @return the MetricName object itself.
     */
    public MetricName withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the localizedValue property: The localized name of the metric.
     * 
     * @return the localizedValue value.
     */
    public String localizedValue() {
        return this.localizedValue;
    }

    /**
     * Set the localizedValue property: The localized name of the metric.
     * 
     * @param localizedValue the localizedValue value to set.
     * @return the MetricName object itself.
     */
    public MetricName withLocalizedValue(String localizedValue) {
        this.localizedValue = localizedValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("localizedValue", this.localizedValue);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricName from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricName if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the MetricName.
     */
    public static MetricName fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricName deserializedMetricName = new MetricName();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedMetricName.value = reader.getString();
                } else if ("localizedValue".equals(fieldName)) {
                    deserializedMetricName.localizedValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricName;
        });
    }
}
