// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The private link scope resource reference.
 */
@Fluent
public final class PrivateLinkScopedResource implements JsonSerializable<PrivateLinkScopedResource> {
    /*
     * The full resource Id of the private link scope resource.
     */
    private String resourceId;

    /*
     * The private link scope unique Identifier.
     */
    private String scopeId;

    /**
     * Creates an instance of PrivateLinkScopedResource class.
     */
    public PrivateLinkScopedResource() {
    }

    /**
     * Get the resourceId property: The full resource Id of the private link scope resource.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The full resource Id of the private link scope resource.
     * 
     * @param resourceId the resourceId value to set.
     * @return the PrivateLinkScopedResource object itself.
     */
    public PrivateLinkScopedResource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the scopeId property: The private link scope unique Identifier.
     * 
     * @return the scopeId value.
     */
    public String scopeId() {
        return this.scopeId;
    }

    /**
     * Set the scopeId property: The private link scope unique Identifier.
     * 
     * @param scopeId the scopeId value to set.
     * @return the PrivateLinkScopedResource object itself.
     */
    public PrivateLinkScopedResource withScopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("scopeId", this.scopeId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkScopedResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkScopedResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateLinkScopedResource.
     */
    public static PrivateLinkScopedResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkScopedResource deserializedPrivateLinkScopedResource = new PrivateLinkScopedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedPrivateLinkScopedResource.resourceId = reader.getString();
                } else if ("scopeId".equals(fieldName)) {
                    deserializedPrivateLinkScopedResource.scopeId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkScopedResource;
        });
    }
}
