// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Metadata for search results.
 */
@Fluent
public final class SearchMetadata implements JsonSerializable<SearchMetadata> {
    /*
     * The request id of the search.
     */
    private String searchId;

    /*
     * The search result type.
     */
    private String resultType;

    /*
     * The total number of search results.
     */
    private Long total;

    /*
     * The number of top search results.
     */
    private Long top;

    /*
     * The id of the search results request.
     */
    private String id;

    /*
     * The core summaries.
     */
    private List<CoreSummary> coreSummaries;

    /*
     * The status of the search results.
     */
    private String status;

    /*
     * The start time for the search.
     */
    private OffsetDateTime startTime;

    /*
     * The time of last update.
     */
    private OffsetDateTime lastUpdated;

    /*
     * The ETag of the search results.
     */
    private String etag;

    /*
     * How the results are sorted.
     */
    private List<SearchSort> sort;

    /*
     * The request time.
     */
    private Long requestTime;

    /*
     * The aggregated value field.
     */
    private String aggregatedValueField;

    /*
     * The aggregated grouping fields.
     */
    private String aggregatedGroupingFields;

    /*
     * The sum of all aggregates returned in the result set.
     */
    private Long sum;

    /*
     * The max of all aggregates returned in the result set.
     */
    private Long max;

    /*
     * The schema.
     */
    private SearchMetadataSchema schema;

    /**
     * Creates an instance of SearchMetadata class.
     */
    public SearchMetadata() {
    }

    /**
     * Get the searchId property: The request id of the search.
     * 
     * @return the searchId value.
     */
    public String searchId() {
        return this.searchId;
    }

    /**
     * Set the searchId property: The request id of the search.
     * 
     * @param searchId the searchId value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withSearchId(String searchId) {
        this.searchId = searchId;
        return this;
    }

    /**
     * Get the resultType property: The search result type.
     * 
     * @return the resultType value.
     */
    public String resultType() {
        return this.resultType;
    }

    /**
     * Set the resultType property: The search result type.
     * 
     * @param resultType the resultType value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withResultType(String resultType) {
        this.resultType = resultType;
        return this;
    }

    /**
     * Get the total property: The total number of search results.
     * 
     * @return the total value.
     */
    public Long total() {
        return this.total;
    }

    /**
     * Set the total property: The total number of search results.
     * 
     * @param total the total value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withTotal(Long total) {
        this.total = total;
        return this;
    }

    /**
     * Get the top property: The number of top search results.
     * 
     * @return the top value.
     */
    public Long top() {
        return this.top;
    }

    /**
     * Set the top property: The number of top search results.
     * 
     * @param top the top value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withTop(Long top) {
        this.top = top;
        return this;
    }

    /**
     * Get the id property: The id of the search results request.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id of the search results request.
     * 
     * @param id the id value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the coreSummaries property: The core summaries.
     * 
     * @return the coreSummaries value.
     */
    public List<CoreSummary> coreSummaries() {
        return this.coreSummaries;
    }

    /**
     * Set the coreSummaries property: The core summaries.
     * 
     * @param coreSummaries the coreSummaries value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withCoreSummaries(List<CoreSummary> coreSummaries) {
        this.coreSummaries = coreSummaries;
        return this;
    }

    /**
     * Get the status property: The status of the search results.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the search results.
     * 
     * @param status the status value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the startTime property: The start time for the search.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The start time for the search.
     * 
     * @param startTime the startTime value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the lastUpdated property: The time of last update.
     * 
     * @return the lastUpdated value.
     */
    public OffsetDateTime lastUpdated() {
        return this.lastUpdated;
    }

    /**
     * Set the lastUpdated property: The time of last update.
     * 
     * @param lastUpdated the lastUpdated value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * Get the etag property: The ETag of the search results.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: The ETag of the search results.
     * 
     * @param etag the etag value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the sort property: How the results are sorted.
     * 
     * @return the sort value.
     */
    public List<SearchSort> sort() {
        return this.sort;
    }

    /**
     * Set the sort property: How the results are sorted.
     * 
     * @param sort the sort value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withSort(List<SearchSort> sort) {
        this.sort = sort;
        return this;
    }

    /**
     * Get the requestTime property: The request time.
     * 
     * @return the requestTime value.
     */
    public Long requestTime() {
        return this.requestTime;
    }

    /**
     * Set the requestTime property: The request time.
     * 
     * @param requestTime the requestTime value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withRequestTime(Long requestTime) {
        this.requestTime = requestTime;
        return this;
    }

    /**
     * Get the aggregatedValueField property: The aggregated value field.
     * 
     * @return the aggregatedValueField value.
     */
    public String aggregatedValueField() {
        return this.aggregatedValueField;
    }

    /**
     * Set the aggregatedValueField property: The aggregated value field.
     * 
     * @param aggregatedValueField the aggregatedValueField value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withAggregatedValueField(String aggregatedValueField) {
        this.aggregatedValueField = aggregatedValueField;
        return this;
    }

    /**
     * Get the aggregatedGroupingFields property: The aggregated grouping fields.
     * 
     * @return the aggregatedGroupingFields value.
     */
    public String aggregatedGroupingFields() {
        return this.aggregatedGroupingFields;
    }

    /**
     * Set the aggregatedGroupingFields property: The aggregated grouping fields.
     * 
     * @param aggregatedGroupingFields the aggregatedGroupingFields value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withAggregatedGroupingFields(String aggregatedGroupingFields) {
        this.aggregatedGroupingFields = aggregatedGroupingFields;
        return this;
    }

    /**
     * Get the sum property: The sum of all aggregates returned in the result set.
     * 
     * @return the sum value.
     */
    public Long sum() {
        return this.sum;
    }

    /**
     * Set the sum property: The sum of all aggregates returned in the result set.
     * 
     * @param sum the sum value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withSum(Long sum) {
        this.sum = sum;
        return this;
    }

    /**
     * Get the max property: The max of all aggregates returned in the result set.
     * 
     * @return the max value.
     */
    public Long max() {
        return this.max;
    }

    /**
     * Set the max property: The max of all aggregates returned in the result set.
     * 
     * @param max the max value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withMax(Long max) {
        this.max = max;
        return this;
    }

    /**
     * Get the schema property: The schema.
     * 
     * @return the schema value.
     */
    public SearchMetadataSchema schema() {
        return this.schema;
    }

    /**
     * Set the schema property: The schema.
     * 
     * @param schema the schema value to set.
     * @return the SearchMetadata object itself.
     */
    public SearchMetadata withSchema(SearchMetadataSchema schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (coreSummaries() != null) {
            coreSummaries().forEach(e -> e.validate());
        }
        if (sort() != null) {
            sort().forEach(e -> e.validate());
        }
        if (schema() != null) {
            schema().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("requestId", this.searchId);
        jsonWriter.writeStringField("resultType", this.resultType);
        jsonWriter.writeNumberField("total", this.total);
        jsonWriter.writeNumberField("top", this.top);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("coreSummaries", this.coreSummaries, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("lastUpdated",
            this.lastUpdated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdated));
        jsonWriter.writeStringField("eTag", this.etag);
        jsonWriter.writeArrayField("sort", this.sort, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("requestTime", this.requestTime);
        jsonWriter.writeStringField("aggregatedValueField", this.aggregatedValueField);
        jsonWriter.writeStringField("aggregatedGroupingFields", this.aggregatedGroupingFields);
        jsonWriter.writeNumberField("sum", this.sum);
        jsonWriter.writeNumberField("max", this.max);
        jsonWriter.writeJsonField("schema", this.schema);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchMetadata if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchMetadata.
     */
    public static SearchMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchMetadata deserializedSearchMetadata = new SearchMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("requestId".equals(fieldName)) {
                    deserializedSearchMetadata.searchId = reader.getString();
                } else if ("resultType".equals(fieldName)) {
                    deserializedSearchMetadata.resultType = reader.getString();
                } else if ("total".equals(fieldName)) {
                    deserializedSearchMetadata.total = reader.getNullable(JsonReader::getLong);
                } else if ("top".equals(fieldName)) {
                    deserializedSearchMetadata.top = reader.getNullable(JsonReader::getLong);
                } else if ("id".equals(fieldName)) {
                    deserializedSearchMetadata.id = reader.getString();
                } else if ("coreSummaries".equals(fieldName)) {
                    List<CoreSummary> coreSummaries = reader.readArray(reader1 -> CoreSummary.fromJson(reader1));
                    deserializedSearchMetadata.coreSummaries = coreSummaries;
                } else if ("status".equals(fieldName)) {
                    deserializedSearchMetadata.status = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedSearchMetadata.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastUpdated".equals(fieldName)) {
                    deserializedSearchMetadata.lastUpdated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("eTag".equals(fieldName)) {
                    deserializedSearchMetadata.etag = reader.getString();
                } else if ("sort".equals(fieldName)) {
                    List<SearchSort> sort = reader.readArray(reader1 -> SearchSort.fromJson(reader1));
                    deserializedSearchMetadata.sort = sort;
                } else if ("requestTime".equals(fieldName)) {
                    deserializedSearchMetadata.requestTime = reader.getNullable(JsonReader::getLong);
                } else if ("aggregatedValueField".equals(fieldName)) {
                    deserializedSearchMetadata.aggregatedValueField = reader.getString();
                } else if ("aggregatedGroupingFields".equals(fieldName)) {
                    deserializedSearchMetadata.aggregatedGroupingFields = reader.getString();
                } else if ("sum".equals(fieldName)) {
                    deserializedSearchMetadata.sum = reader.getNullable(JsonReader::getLong);
                } else if ("max".equals(fieldName)) {
                    deserializedSearchMetadata.max = reader.getNullable(JsonReader::getLong);
                } else if ("schema".equals(fieldName)) {
                    deserializedSearchMetadata.schema = SearchMetadataSchema.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchMetadata;
        });
    }
}
