// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema metadata for search.
 */
@Fluent
public final class SearchMetadataSchema implements JsonSerializable<SearchMetadataSchema> {
    /*
     * The name of the metadata schema.
     */
    private String name;

    /*
     * The version of the metadata schema.
     */
    private Integer version;

    /**
     * Creates an instance of SearchMetadataSchema class.
     */
    public SearchMetadataSchema() {
    }

    /**
     * Get the name property: The name of the metadata schema.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the metadata schema.
     * 
     * @param name the name value to set.
     * @return the SearchMetadataSchema object itself.
     */
    public SearchMetadataSchema withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the version property: The version of the metadata schema.
     * 
     * @return the version value.
     */
    public Integer version() {
        return this.version;
    }

    /**
     * Set the version property: The version of the metadata schema.
     * 
     * @param version the version value to set.
     * @return the SearchMetadataSchema object itself.
     */
    public SearchMetadataSchema withVersion(Integer version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchMetadataSchema from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchMetadataSchema if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchMetadataSchema.
     */
    public static SearchMetadataSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchMetadataSchema deserializedSearchMetadataSchema = new SearchMetadataSchema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSearchMetadataSchema.name = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedSearchMetadataSchema.version = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchMetadataSchema;
        });
    }
}
