// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Parameters of the search job that initiated this table.
 */
@Fluent
public final class SearchResults implements JsonSerializable<SearchResults> {
    /*
     * Search job query.
     */
    private String query;

    /*
     * Search job Description.
     */
    private String description;

    /*
     * Limit the search job to return up to specified number of rows.
     */
    private Integer limit;

    /*
     * The timestamp to start the search from (UTC)
     */
    private OffsetDateTime startSearchTime;

    /*
     * The timestamp to end the search by (UTC)
     */
    private OffsetDateTime endSearchTime;

    /*
     * The table used in the search job.
     */
    private String sourceTable;

    /*
     * Search results table async operation id.
     */
    private String azureAsyncOperationId;

    /**
     * Creates an instance of SearchResults class.
     */
    public SearchResults() {
    }

    /**
     * Get the query property: Search job query.
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: Search job query.
     * 
     * @param query the query value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the description property: Search job Description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Search job Description.
     * 
     * @param description the description value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the limit property: Limit the search job to return up to specified number of rows.
     * 
     * @return the limit value.
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Set the limit property: Limit the search job to return up to specified number of rows.
     * 
     * @param limit the limit value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    /**
     * Get the startSearchTime property: The timestamp to start the search from (UTC).
     * 
     * @return the startSearchTime value.
     */
    public OffsetDateTime startSearchTime() {
        return this.startSearchTime;
    }

    /**
     * Set the startSearchTime property: The timestamp to start the search from (UTC).
     * 
     * @param startSearchTime the startSearchTime value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withStartSearchTime(OffsetDateTime startSearchTime) {
        this.startSearchTime = startSearchTime;
        return this;
    }

    /**
     * Get the endSearchTime property: The timestamp to end the search by (UTC).
     * 
     * @return the endSearchTime value.
     */
    public OffsetDateTime endSearchTime() {
        return this.endSearchTime;
    }

    /**
     * Set the endSearchTime property: The timestamp to end the search by (UTC).
     * 
     * @param endSearchTime the endSearchTime value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withEndSearchTime(OffsetDateTime endSearchTime) {
        this.endSearchTime = endSearchTime;
        return this;
    }

    /**
     * Get the sourceTable property: The table used in the search job.
     * 
     * @return the sourceTable value.
     */
    public String sourceTable() {
        return this.sourceTable;
    }

    /**
     * Get the azureAsyncOperationId property: Search results table async operation id.
     * 
     * @return the azureAsyncOperationId value.
     */
    public String azureAsyncOperationId() {
        return this.azureAsyncOperationId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeNumberField("limit", this.limit);
        jsonWriter.writeStringField("startSearchTime",
            this.startSearchTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startSearchTime));
        jsonWriter.writeStringField("endSearchTime",
            this.endSearchTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endSearchTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchResults from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchResults if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchResults.
     */
    public static SearchResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchResults deserializedSearchResults = new SearchResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("query".equals(fieldName)) {
                    deserializedSearchResults.query = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedSearchResults.description = reader.getString();
                } else if ("limit".equals(fieldName)) {
                    deserializedSearchResults.limit = reader.getNullable(JsonReader::getInt);
                } else if ("startSearchTime".equals(fieldName)) {
                    deserializedSearchResults.startSearchTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endSearchTime".equals(fieldName)) {
                    deserializedSearchResults.endSearchTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("sourceTable".equals(fieldName)) {
                    deserializedSearchResults.sourceTable = reader.getString();
                } else if ("azureAsyncOperationId".equals(fieldName)) {
                    deserializedSearchResults.azureAsyncOperationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchResults;
        });
    }
}
