// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Value object for schema results.
 */
@Fluent
public final class SearchSchemaValue implements JsonSerializable<SearchSchemaValue> {
    /*
     * The name of the schema.
     */
    private String name;

    /*
     * The display name of the schema.
     */
    private String displayName;

    /*
     * The type.
     */
    private String type;

    /*
     * The boolean that indicates the field is searchable as free text.
     */
    private boolean indexed;

    /*
     * The boolean that indicates whether or not the field is stored.
     */
    private boolean stored;

    /*
     * The boolean that indicates whether or not the field is a facet.
     */
    private boolean facet;

    /*
     * The array of workflows containing the field.
     */
    private List<String> ownerType;

    /**
     * Creates an instance of SearchSchemaValue class.
     */
    public SearchSchemaValue() {
    }

    /**
     * Get the name property: The name of the schema.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the schema.
     * 
     * @param name the name value to set.
     * @return the SearchSchemaValue object itself.
     */
    public SearchSchemaValue withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: The display name of the schema.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the schema.
     * 
     * @param displayName the displayName value to set.
     * @return the SearchSchemaValue object itself.
     */
    public SearchSchemaValue withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the type property: The type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type.
     * 
     * @param type the type value to set.
     * @return the SearchSchemaValue object itself.
     */
    public SearchSchemaValue withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the indexed property: The boolean that indicates the field is searchable as free text.
     * 
     * @return the indexed value.
     */
    public boolean indexed() {
        return this.indexed;
    }

    /**
     * Set the indexed property: The boolean that indicates the field is searchable as free text.
     * 
     * @param indexed the indexed value to set.
     * @return the SearchSchemaValue object itself.
     */
    public SearchSchemaValue withIndexed(boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    /**
     * Get the stored property: The boolean that indicates whether or not the field is stored.
     * 
     * @return the stored value.
     */
    public boolean stored() {
        return this.stored;
    }

    /**
     * Set the stored property: The boolean that indicates whether or not the field is stored.
     * 
     * @param stored the stored value to set.
     * @return the SearchSchemaValue object itself.
     */
    public SearchSchemaValue withStored(boolean stored) {
        this.stored = stored;
        return this;
    }

    /**
     * Get the facet property: The boolean that indicates whether or not the field is a facet.
     * 
     * @return the facet value.
     */
    public boolean facet() {
        return this.facet;
    }

    /**
     * Set the facet property: The boolean that indicates whether or not the field is a facet.
     * 
     * @param facet the facet value to set.
     * @return the SearchSchemaValue object itself.
     */
    public SearchSchemaValue withFacet(boolean facet) {
        this.facet = facet;
        return this;
    }

    /**
     * Get the ownerType property: The array of workflows containing the field.
     * 
     * @return the ownerType value.
     */
    public List<String> ownerType() {
        return this.ownerType;
    }

    /**
     * Set the ownerType property: The array of workflows containing the field.
     * 
     * @param ownerType the ownerType value to set.
     * @return the SearchSchemaValue object itself.
     */
    public SearchSchemaValue withOwnerType(List<String> ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("indexed", this.indexed);
        jsonWriter.writeBooleanField("stored", this.stored);
        jsonWriter.writeBooleanField("facet", this.facet);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeArrayField("ownerType", this.ownerType, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchSchemaValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchSchemaValue if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchSchemaValue.
     */
    public static SearchSchemaValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchSchemaValue deserializedSearchSchemaValue = new SearchSchemaValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("indexed".equals(fieldName)) {
                    deserializedSearchSchemaValue.indexed = reader.getBoolean();
                } else if ("stored".equals(fieldName)) {
                    deserializedSearchSchemaValue.stored = reader.getBoolean();
                } else if ("facet".equals(fieldName)) {
                    deserializedSearchSchemaValue.facet = reader.getBoolean();
                } else if ("name".equals(fieldName)) {
                    deserializedSearchSchemaValue.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedSearchSchemaValue.displayName = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSearchSchemaValue.type = reader.getString();
                } else if ("ownerType".equals(fieldName)) {
                    List<String> ownerType = reader.readArray(reader1 -> reader1.getString());
                    deserializedSearchSchemaValue.ownerType = ownerType;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchSchemaValue;
        });
    }
}
