// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The sort parameters for search.
 */
@Fluent
public final class SearchSort implements JsonSerializable<SearchSort> {
    /*
     * The name of the field the search query is sorted on.
     */
    private String name;

    /*
     * The sort order of the search.
     */
    private SearchSortEnum order;

    /**
     * Creates an instance of SearchSort class.
     */
    public SearchSort() {
    }

    /**
     * Get the name property: The name of the field the search query is sorted on.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the field the search query is sorted on.
     * 
     * @param name the name value to set.
     * @return the SearchSort object itself.
     */
    public SearchSort withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the order property: The sort order of the search.
     * 
     * @return the order value.
     */
    public SearchSortEnum order() {
        return this.order;
    }

    /**
     * Set the order property: The sort order of the search.
     * 
     * @param order the order value to set.
     * @return the SearchSort object itself.
     */
    public SearchSort withOrder(SearchSortEnum order) {
        this.order = order;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("order", this.order == null ? null : this.order.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchSort from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchSort if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SearchSort.
     */
    public static SearchSort fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchSort deserializedSearchSort = new SearchSort();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSearchSort.name = reader.getString();
                } else if ("order".equals(fieldName)) {
                    deserializedSearchSort.order = SearchSortEnum.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchSort;
        });
    }
}
