// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.fluent.models.StorageInsightInner;
import java.io.IOException;
import java.util.List;

/**
 * The list storage insights operation response.
 */
@Fluent
public final class StorageInsightListResult implements JsonSerializable<StorageInsightListResult> {
    /*
     * A list of storage insight items.
     */
    private List<StorageInsightInner> value;

    /*
     * The link (url) to the next page of results.
     */
    private String odataNextLink;

    /**
     * Creates an instance of StorageInsightListResult class.
     */
    public StorageInsightListResult() {
    }

    /**
     * Get the value property: A list of storage insight items.
     * 
     * @return the value value.
     */
    public List<StorageInsightInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of storage insight items.
     * 
     * @param value the value value to set.
     * @return the StorageInsightListResult object itself.
     */
    public StorageInsightListResult withValue(List<StorageInsightInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the odataNextLink property: The link (url) to the next page of results.
     * 
     * @return the odataNextLink value.
     */
    public String odataNextLink() {
        return this.odataNextLink;
    }

    /**
     * Set the odataNextLink property: The link (url) to the next page of results.
     * 
     * @param odataNextLink the odataNextLink value to set.
     * @return the StorageInsightListResult object itself.
     */
    public StorageInsightListResult withOdataNextLink(String odataNextLink) {
        this.odataNextLink = odataNextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("@odata.nextLink", this.odataNextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageInsightListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageInsightListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageInsightListResult.
     */
    public static StorageInsightListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageInsightListResult deserializedStorageInsightListResult = new StorageInsightListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<StorageInsightInner> value
                        = reader.readArray(reader1 -> StorageInsightInner.fromJson(reader1));
                    deserializedStorageInsightListResult.value = value;
                } else if ("@odata.nextLink".equals(fieldName)) {
                    deserializedStorageInsightListResult.odataNextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageInsightListResult;
        });
    }
}
