// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The state of the storage insight connection to the workspace.
 */
public final class StorageInsightState extends ExpandableStringEnum<StorageInsightState> {
    /**
     * Static value OK for StorageInsightState.
     */
    public static final StorageInsightState OK = fromString("OK");

    /**
     * Static value ERROR for StorageInsightState.
     */
    public static final StorageInsightState ERROR = fromString("ERROR");

    /**
     * Creates a new instance of StorageInsightState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StorageInsightState() {
    }

    /**
     * Creates or finds a StorageInsightState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StorageInsightState.
     */
    public static StorageInsightState fromString(String name) {
        return fromString(name, StorageInsightState.class);
    }

    /**
     * Gets known StorageInsightState values.
     * 
     * @return known StorageInsightState values.
     */
    public static Collection<StorageInsightState> values() {
        return values(StorageInsightState.class);
    }
}
