// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A tag of a saved search.
 */
@Fluent
public final class Tag implements JsonSerializable<Tag> {
    /*
     * The tag name.
     */
    private String name;

    /*
     * The tag value.
     */
    private String value;

    /**
     * Creates an instance of Tag class.
     */
    public Tag() {
    }

    /**
     * Get the name property: The tag name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The tag name.
     * 
     * @param name the name value to set.
     * @return the Tag object itself.
     */
    public Tag withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The tag value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The tag value.
     * 
     * @param value the value value to set.
     * @return the Tag object itself.
     */
    public Tag withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Tag"));
        }
        if (value() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property value in model Tag"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Tag.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Tag from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Tag if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Tag.
     */
    public static Tag fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Tag deserializedTag = new Tag();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedTag.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedTag.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTag;
        });
    }
}
