// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The daily volume cap for ingestion.
 */
@Fluent
public final class WorkspaceCapping implements JsonSerializable<WorkspaceCapping> {
    /*
     * The workspace daily quota for ingestion.
     */
    private Double dailyQuotaGb;

    /*
     * The time when the quota will be rest.
     */
    private String quotaNextResetTime;

    /*
     * The status of data ingestion for this workspace.
     */
    private DataIngestionStatus dataIngestionStatus;

    /**
     * Creates an instance of WorkspaceCapping class.
     */
    public WorkspaceCapping() {
    }

    /**
     * Get the dailyQuotaGb property: The workspace daily quota for ingestion.
     * 
     * @return the dailyQuotaGb value.
     */
    public Double dailyQuotaGb() {
        return this.dailyQuotaGb;
    }

    /**
     * Set the dailyQuotaGb property: The workspace daily quota for ingestion.
     * 
     * @param dailyQuotaGb the dailyQuotaGb value to set.
     * @return the WorkspaceCapping object itself.
     */
    public WorkspaceCapping withDailyQuotaGb(Double dailyQuotaGb) {
        this.dailyQuotaGb = dailyQuotaGb;
        return this;
    }

    /**
     * Get the quotaNextResetTime property: The time when the quota will be rest.
     * 
     * @return the quotaNextResetTime value.
     */
    public String quotaNextResetTime() {
        return this.quotaNextResetTime;
    }

    /**
     * Get the dataIngestionStatus property: The status of data ingestion for this workspace.
     * 
     * @return the dataIngestionStatus value.
     */
    public DataIngestionStatus dataIngestionStatus() {
        return this.dataIngestionStatus;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("dailyQuotaGb", this.dailyQuotaGb);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceCapping from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceCapping if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkspaceCapping.
     */
    public static WorkspaceCapping fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceCapping deserializedWorkspaceCapping = new WorkspaceCapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dailyQuotaGb".equals(fieldName)) {
                    deserializedWorkspaceCapping.dailyQuotaGb = reader.getNullable(JsonReader::getDouble);
                } else if ("quotaNextResetTime".equals(fieldName)) {
                    deserializedWorkspaceCapping.quotaNextResetTime = reader.getString();
                } else if ("dataIngestionStatus".equals(fieldName)) {
                    deserializedWorkspaceCapping.dataIngestionStatus
                        = DataIngestionStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceCapping;
        });
    }
}
