// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Workspace features.
 */
@Fluent
public final class WorkspaceFeatures implements JsonSerializable<WorkspaceFeatures> {
    /*
     * Flag that indicate if data should be exported.
     */
    private Boolean enableDataExport;

    /*
     * Flag that describes if we want to remove the data after 30 days.
     */
    private Boolean immediatePurgeDataOn30Days;

    /*
     * Flag that indicate which permission to use - resource or workspace or both.
     */
    private Boolean enableLogAccessUsingOnlyResourcePermissions;

    /*
     * Dedicated LA cluster resourceId that is linked to the workspaces.
     */
    private String clusterResourceId;

    /*
     * Disable Non-AAD based Auth.
     */
    private Boolean disableLocalAuth;

    /*
     * Workspace features.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of WorkspaceFeatures class.
     */
    public WorkspaceFeatures() {
    }

    /**
     * Get the enableDataExport property: Flag that indicate if data should be exported.
     * 
     * @return the enableDataExport value.
     */
    public Boolean enableDataExport() {
        return this.enableDataExport;
    }

    /**
     * Set the enableDataExport property: Flag that indicate if data should be exported.
     * 
     * @param enableDataExport the enableDataExport value to set.
     * @return the WorkspaceFeatures object itself.
     */
    public WorkspaceFeatures withEnableDataExport(Boolean enableDataExport) {
        this.enableDataExport = enableDataExport;
        return this;
    }

    /**
     * Get the immediatePurgeDataOn30Days property: Flag that describes if we want to remove the data after 30 days.
     * 
     * @return the immediatePurgeDataOn30Days value.
     */
    public Boolean immediatePurgeDataOn30Days() {
        return this.immediatePurgeDataOn30Days;
    }

    /**
     * Set the immediatePurgeDataOn30Days property: Flag that describes if we want to remove the data after 30 days.
     * 
     * @param immediatePurgeDataOn30Days the immediatePurgeDataOn30Days value to set.
     * @return the WorkspaceFeatures object itself.
     */
    public WorkspaceFeatures withImmediatePurgeDataOn30Days(Boolean immediatePurgeDataOn30Days) {
        this.immediatePurgeDataOn30Days = immediatePurgeDataOn30Days;
        return this;
    }

    /**
     * Get the enableLogAccessUsingOnlyResourcePermissions property: Flag that indicate which permission to use -
     * resource or workspace or both.
     * 
     * @return the enableLogAccessUsingOnlyResourcePermissions value.
     */
    public Boolean enableLogAccessUsingOnlyResourcePermissions() {
        return this.enableLogAccessUsingOnlyResourcePermissions;
    }

    /**
     * Set the enableLogAccessUsingOnlyResourcePermissions property: Flag that indicate which permission to use -
     * resource or workspace or both.
     * 
     * @param enableLogAccessUsingOnlyResourcePermissions the enableLogAccessUsingOnlyResourcePermissions value to set.
     * @return the WorkspaceFeatures object itself.
     */
    public WorkspaceFeatures
        withEnableLogAccessUsingOnlyResourcePermissions(Boolean enableLogAccessUsingOnlyResourcePermissions) {
        this.enableLogAccessUsingOnlyResourcePermissions = enableLogAccessUsingOnlyResourcePermissions;
        return this;
    }

    /**
     * Get the clusterResourceId property: Dedicated LA cluster resourceId that is linked to the workspaces.
     * 
     * @return the clusterResourceId value.
     */
    public String clusterResourceId() {
        return this.clusterResourceId;
    }

    /**
     * Set the clusterResourceId property: Dedicated LA cluster resourceId that is linked to the workspaces.
     * 
     * @param clusterResourceId the clusterResourceId value to set.
     * @return the WorkspaceFeatures object itself.
     */
    public WorkspaceFeatures withClusterResourceId(String clusterResourceId) {
        this.clusterResourceId = clusterResourceId;
        return this;
    }

    /**
     * Get the disableLocalAuth property: Disable Non-AAD based Auth.
     * 
     * @return the disableLocalAuth value.
     */
    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    /**
     * Set the disableLocalAuth property: Disable Non-AAD based Auth.
     * 
     * @param disableLocalAuth the disableLocalAuth value to set.
     * @return the WorkspaceFeatures object itself.
     */
    public WorkspaceFeatures withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    /**
     * Get the additionalProperties property: Workspace features.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Workspace features.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the WorkspaceFeatures object itself.
     */
    public WorkspaceFeatures withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableDataExport", this.enableDataExport);
        jsonWriter.writeBooleanField("immediatePurgeDataOn30Days", this.immediatePurgeDataOn30Days);
        jsonWriter.writeBooleanField("enableLogAccessUsingOnlyResourcePermissions",
            this.enableLogAccessUsingOnlyResourcePermissions);
        jsonWriter.writeStringField("clusterResourceId", this.clusterResourceId);
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceFeatures from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceFeatures if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkspaceFeatures.
     */
    public static WorkspaceFeatures fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceFeatures deserializedWorkspaceFeatures = new WorkspaceFeatures();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enableDataExport".equals(fieldName)) {
                    deserializedWorkspaceFeatures.enableDataExport = reader.getNullable(JsonReader::getBoolean);
                } else if ("immediatePurgeDataOn30Days".equals(fieldName)) {
                    deserializedWorkspaceFeatures.immediatePurgeDataOn30Days
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableLogAccessUsingOnlyResourcePermissions".equals(fieldName)) {
                    deserializedWorkspaceFeatures.enableLogAccessUsingOnlyResourcePermissions
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("clusterResourceId".equals(fieldName)) {
                    deserializedWorkspaceFeatures.clusterResourceId = reader.getString();
                } else if ("disableLocalAuth".equals(fieldName)) {
                    deserializedWorkspaceFeatures.disableLocalAuth = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedWorkspaceFeatures.additionalProperties = additionalProperties;

            return deserializedWorkspaceFeatures;
        });
    }
}
